/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.operation;

import java.util.Map;
import org.mule.connectors.atlantic.commons.builder.execution.ExecutionBuilder;
import org.mule.connectors.commons.template.config.ConnectorConfig;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.connectors.commons.template.operation.ConnectorOperations;
import org.mule.extension.ldap.internal.config.LDAPConfiguration;
import org.mule.extension.ldap.internal.connection.LDAPConnection;
import org.mule.extension.ldap.internal.error.LDAPErrorType;
import org.mule.extension.ldap.internal.error.exception.LDAPException;
import org.mule.extension.ldap.internal.error.provider.LDAPErrorTypeProvider;
import org.mule.extension.ldap.internal.metadata.LDAPEntryObjectClassMetadataResolver;
import org.mule.extension.ldap.internal.service.ConnectionOperationsService;
import org.mule.extension.ldap.internal.service.ConnectionOperationsServiceImpl;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Password;

@Throws(value={LDAPErrorTypeProvider.class})
public class ConnectionOperations
extends ConnectorOperations<LDAPConfiguration, LDAPConnection, ConnectionOperationsService> {
    public ConnectionOperations() {
        super(ConnectionOperationsServiceImpl::new);
    }

    @OutputResolver(output=LDAPEntryObjectClassMetadataResolver.class)
    public Map<String, Object> bind(@Config LDAPConfiguration configuration, @Connection LDAPConnection ldapConnection, @DisplayName(value="Principal DN") @Optional String authDn, @DisplayName(value="Password") @Password @Optional String authPassword, @Optional String authentication) {
        return (Map)this.newExecutionBuilder(configuration, ldapConnection).execute(ConnectionOperationsService::bind).withParam((Object)authDn).withParam((Object)authPassword).withParam((Object)authentication);
    }

    public void unbind(@Config LDAPConfiguration configuration, @Connection LDAPConnection ldapConnection) {
        this.newExecutionBuilder(configuration, ldapConnection).execute(ConnectionOperationsService::unbind);
    }

    protected ExecutionBuilder<ConnectionOperationsService> newExecutionBuilder(LDAPConfiguration config, LDAPConnection connection) {
        return (ExecutionBuilder)((ExecutionBuilder)((ExecutionBuilder)super.newExecutionBuilder((ConnectorConfig)config, (ConnectorConnection)connection).withExceptionHandler(Exception.class, exception -> {
            throw new LDAPException(LDAPErrorType.UNKNOWN, exception);
        })).withExceptionHandler(LDAPException.class, exception -> {
            throw exception;
        })).withExceptionHandler(ConnectionException.class, exception -> {
            throw new LDAPException(exception.getMessage(), LDAPErrorType.CONNECTIVITY, exception);
        });
    }
}

