/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.mule.extension.ldap.internal.model.LDAPEntryAttribute;

public class LDAPMultiValueEntryAttribute
extends LDAPEntryAttribute {
    private static final long serialVersionUID = 2022378719197583814L;
    private final List<Object> values = new ArrayList<Object>();

    public LDAPMultiValueEntryAttribute() {
    }

    public LDAPMultiValueEntryAttribute(String name, Object[] values) {
        this(name);
        this.addValues(values);
    }

    public LDAPMultiValueEntryAttribute(String name, Collection<Object> values) {
        this(name);
        this.addValues(values != null ? values.toArray() : null);
    }

    public LDAPMultiValueEntryAttribute(String name) {
        super(name);
    }

    @Override
    public Object getValue() {
        return !this.values.isEmpty() ? this.values.get(0) : null;
    }

    @Override
    public List<Object> getValues() {
        ArrayList<Object> listOfValues = new ArrayList<Object>();
        listOfValues.addAll(this.values);
        return listOfValues;
    }

    @Override
    public boolean isMultiValued() {
        return true;
    }

    public void addValue(Object value) {
        this.values.add(value);
    }

    public void addValues(Object[] values) {
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                this.values.add(values[i]);
            }
        }
    }
}

