/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.error.exception.util;

import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.ContextNotEmptyException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.OperationNotSupportedException;
import javax.naming.PartialResultException;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.InvalidAttributesException;
import javax.naming.directory.SchemaViolationException;
import org.mule.extension.ldap.internal.error.LDAPErrorType;
import org.mule.extension.ldap.internal.error.exception.LDAPException;
import org.mule.runtime.api.connection.ConnectionException;

public class ExceptionUtils {
    private ExceptionUtils() {
    }

    public static ConnectionException toConnectionException(Exception ex) {
        return new ConnectionException(ex.getMessage(), (Throwable)ex);
    }

    public static LDAPException buildLdapException(NamingException exception) {
        LDAPException ldapException = exception instanceof AuthenticationException || exception instanceof CommunicationException ? new LDAPException(exception.getMessage(), LDAPErrorType.CONNECTIVITY, exception) : (exception instanceof NameNotFoundException ? new LDAPException(exception.getMessage(), LDAPErrorType.NAME_NOT_FOUND, exception) : (exception instanceof NoPermissionException ? new LDAPException(exception.getMessage(), LDAPErrorType.PERMISSION, exception) : (exception instanceof InvalidAttributeValueException ? new LDAPException(exception.getMessage(), LDAPErrorType.INVALID_ATTRIBUTE, exception) : (exception instanceof InvalidAttributesException || exception instanceof SchemaViolationException ? new LDAPException(exception.getMessage(), LDAPErrorType.INVALID_ENTRY, exception) : (exception instanceof NameAlreadyBoundException ? new LDAPException(exception.getMessage(), LDAPErrorType.NAME_ALREADY_BOUND, exception) : (exception instanceof ContextNotEmptyException ? new LDAPException(exception.getMessage(), LDAPErrorType.CONTEXT_NOT_EMPTY, exception) : (exception instanceof OperationNotSupportedException ? new LDAPException(exception.getMessage(), LDAPErrorType.OPERATION_NOT_SUPPORTED, exception) : (exception instanceof PartialResultException ? new LDAPException(exception.getMessage(), LDAPErrorType.OPERATION_NOT_COMPLETED, exception) : new LDAPException(exception.getMessage(), LDAPErrorType.UNKNOWN, exception)))))))));
        return ldapException;
    }
}

