/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.error.exception;

import java.util.Optional;
import org.mule.extension.ldap.internal.error.ErrorContent;
import org.mule.extension.ldap.internal.error.LDAPErrorType;
import org.mule.runtime.api.exception.ErrorMessageAwareException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class LDAPException
extends ModuleException
implements ErrorMessageAwareException {
    private final Message message;
    private static final long serialVersionUID = 1220777755286608188L;

    public LDAPException(ErrorTypeDefinition code, Throwable cause) {
        super(code, cause);
        this.message = this.buildErrorMessage(cause.getMessage(), (ErrorTypeDefinition<LDAPErrorType>)code);
    }

    public LDAPException(String message, ErrorTypeDefinition code) {
        super(String.format("%s: %s", code, message), code);
        this.message = this.buildErrorMessage(message, (ErrorTypeDefinition<LDAPErrorType>)code);
    }

    public LDAPException(String message, ErrorTypeDefinition code, Throwable cause) {
        super(String.format("%s: %s", code, message), code, cause);
        this.message = this.buildErrorMessage(message, (ErrorTypeDefinition<LDAPErrorType>)code);
    }

    public Message getErrorMessage() {
        return Optional.ofNullable(this.message).orElse(null);
    }

    private Message buildErrorMessage(String message, ErrorTypeDefinition<LDAPErrorType> code) {
        return Message.builder().payload(new TypedValue((Object)new ErrorContent(code.getType(), message), DataType.OBJECT)).build();
    }
}

