/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.connection;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.extension.ldap.api.parameters.Type;
import org.mule.extension.ldap.internal.connection.ConnectionParameters;
import org.mule.extension.ldap.internal.connection.LDAPSchemaAware;
import org.mule.extension.ldap.internal.connection.jndi.LDAPJNDIConnection;
import org.mule.extension.ldap.internal.error.LDAPErrorType;
import org.mule.extension.ldap.internal.error.exception.LDAPException;
import org.mule.extension.ldap.internal.metadata.MetaDataBuilder;
import org.mule.extension.ldap.internal.model.LDAPEntry;
import org.mule.extension.ldap.internal.model.LDAPEntryAttribute;
import org.mule.extension.ldap.internal.model.LDAPSearchControls;
import org.mule.extension.ldap.internal.util.LDAPResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LDAPConnection
implements LDAPSchemaAware,
ConnectorConnection {
    private static final Logger logger = LoggerFactory.getLogger(LDAPConnection.class);
    public static final boolean DEFAULT_SCHEMA_ENABLED = false;
    public static final boolean DEFAULT_TLS_ENABLED = false;
    public static final boolean DEFAULT_SSL_ENABLED = false;
    protected static final Map<String, Class<?>> CONNECTION_IMPLEMENTATIONS = new HashMap();
    private boolean schemaEnabled = false;
    private boolean tlsEnabled = false;
    private boolean sslEnabled = false;
    private String authentication;
    private MetaDataBuilder metaDataBuilder;
    private final String connectionIdPrefix = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
    public static final String NO_AUTHENTICATION = "none";
    public static final String SIMPLE_AUTHENTICATION = "simple";
    public static final String CONNECTION_TYPE_ATTR = "type";
    public static final String LDAP_URL_ATTR = "url";
    public static final String AUTHENTICATION_ATTR = "authentication";
    public static final String INITIAL_POOL_CONNECTIONS_ATTR = "initialPoolSize";
    public static final String MAX_POOL_CONNECTIONS_ATTR = "maxPoolSize";
    public static final String POOL_TIMEOUT_ATTR = "poolTimeout";
    public static final String REFERRAL_ATTR = "referral";
    public static final String SCHEMA_ENABLED = "schema-enabled";
    public static final String TLS_ENABLED = "tls-enabled";
    public static final String SSL_ENABLED = "ssl-enabled";
    public static final String TRUST_STORE_PATH = "truststore-path";
    public static final String TRUST_STORE_PASSWORD = "truststore-password";

    public static LDAPConnection getConnection(ConnectionParameters connectionParameters) {
        HashMap<String, String> conf = connectionParameters.getExtendedConf() != null ? new HashMap<String, String>(connectionParameters.getExtendedConf()) : new HashMap();
        conf.put(CONNECTION_TYPE_ATTR, connectionParameters.getType());
        conf.put(LDAP_URL_ATTR, connectionParameters.getUrl());
        conf.put(REFERRAL_ATTR, connectionParameters.getReferral());
        conf.put(AUTHENTICATION_ATTR, connectionParameters.getAuthentication());
        conf.put(INITIAL_POOL_CONNECTIONS_ATTR, String.valueOf(connectionParameters.getInitialPoolSize()));
        conf.put(MAX_POOL_CONNECTIONS_ATTR, String.valueOf(connectionParameters.getMaxPoolSize()));
        conf.put(POOL_TIMEOUT_ATTR, String.valueOf(connectionParameters.getPoolTimeout()));
        conf.put(SCHEMA_ENABLED, String.valueOf(connectionParameters.isSchemaEnabled()));
        conf.put(TLS_ENABLED, String.valueOf(connectionParameters.isTlsEnabled()));
        conf.put(SSL_ENABLED, String.valueOf(connectionParameters.isSslEnabled()));
        conf.put(TRUST_STORE_PATH, String.valueOf(connectionParameters.getTrustStorePath()));
        conf.put(TRUST_STORE_PASSWORD, String.valueOf(connectionParameters.getTrustStorePassword()));
        return LDAPConnection.getConnection(conf);
    }

    public static LDAPConnection getConnection(String type, String url, String authentication, int initialPoolSize, int maxPoolSize, long poolTimeout, String referral) {
        ConnectionParameters connectionParameters = new ConnectionParameters.ConnectionParametersBuilder(type, url, authentication).setInitialPoolSize(initialPoolSize).setMaxPoolSize(maxPoolSize).setPoolTimeout(poolTimeout).setReferral(referral).setExtendedConf(new HashMap<String, String>()).build();
        return LDAPConnection.getConnection(connectionParameters);
    }

    public static LDAPConnection getConnection(Map<String, String> conf) {
        try {
            if (!conf.containsKey(CONNECTION_TYPE_ATTR)) {
                throw new LDAPException("Could not instantiate connection as configuration is missing parameter [type]", LDAPErrorType.CONNECTIVITY);
            }
            if (CONNECTION_IMPLEMENTATIONS.get(conf.get(CONNECTION_TYPE_ATTR)) == null) {
                throw new LDAPException("Could not instantiate connection as type [" + conf.get(CONNECTION_TYPE_ATTR) + "] is not supported", LDAPErrorType.CONNECTIVITY);
            }
            LDAPConnection conn = (LDAPConnection)CONNECTION_IMPLEMENTATIONS.get(conf.get(CONNECTION_TYPE_ATTR)).newInstance();
            conn.initialize(conf);
            return conn;
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new LDAPException("Could not instantiate connection from configuration " + conf, LDAPErrorType.CONNECTIVITY, ex);
        }
        catch (Exception ex) {
            throw new LDAPException("Could not obtain connection from configuration " + conf, LDAPErrorType.CONNECTIVITY, ex);
        }
    }

    protected abstract void initialize(Map<String, String> var1);

    public abstract void bind(String var1, String var2);

    public abstract void rebind();

    public abstract LDAPResultSet search(String var1, String var2, Object[] var3, LDAPSearchControls var4);

    public abstract String getBindedUserDn();

    public abstract LDAPResultSet search(String var1, String var2, LDAPSearchControls var3);

    public abstract LDAPEntry lookup(String var1);

    public abstract void renameEntry(String var1, String var2);

    public abstract LDAPEntry lookup(String var1, String[] var2);

    public abstract void addEntry(LDAPEntry var1);

    public abstract void updateEntry(LDAPEntry var1);

    public abstract void deleteEntry(LDAPEntry var1);

    public abstract void deleteEntry(String var1);

    public abstract void addAttribute(String var1, LDAPEntryAttribute var2);

    public abstract void updateAttribute(String var1, LDAPEntryAttribute var2);

    public abstract void deleteAttribute(String var1, LDAPEntryAttribute var2);

    public abstract void close();

    public abstract boolean isClosed();

    @Override
    public boolean isSchemaEnabled() {
        return this.schemaEnabled;
    }

    public void setSchemaEnabled(boolean schemaEnabled) {
        this.schemaEnabled = schemaEnabled;
    }

    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    public void setTlsEnabled(boolean tlsEnabled) {
        this.tlsEnabled = tlsEnabled;
    }

    public abstract void setAuthentication(String var1);

    public abstract void setTrustStore(String var1);

    public abstract void setTrustStorePassword(String var1);

    public abstract boolean isValid();

    public String getAuthentication() {
        return this.authentication;
    }

    public MetaDataBuilder getMetaDataBuilder() {
        return this.metaDataBuilder;
    }

    public void setMetaDataBuilder(MetaDataBuilder metaDataBuilder) {
        this.metaDataBuilder = metaDataBuilder;
    }

    public String getConnectionId() {
        return "[" + this.connectionIdPrefix + "]:" + this;
    }

    public void disconnect() {
        String id = this.getConnectionId();
        logger.debug("About to disconnect {}", (Object)id);
        try {
            this.close();
        }
        catch (LDAPException ex) {
            logger.error("Unable to close connection {}. Forcing close anyway. {}", (Object)id, (Object)ex);
            throw ex;
        }
    }

    public void validate() {
        if (!this.isValid()) {
            throw new LDAPException("Invalid session", LDAPErrorType.CONNECTIVITY);
        }
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
    }

    static {
        CONNECTION_IMPLEMENTATIONS.put(Type.JNDI.toString(), LDAPJNDIConnection.class);
    }
}

