/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.util;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.mule.extension.ldap.internal.util.LDAPTrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPSSLSocketFactory
extends SSLSocketFactory {
    private SSLSocketFactory socketFactory;
    private static final Logger logger = LoggerFactory.getLogger(LDAPSSLSocketFactory.class);

    public LDAPSSLSocketFactory(File trustStoreLoc, String trustStorePassword) {
        try {
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(null, new TrustManager[]{new LDAPTrustManager(trustStoreLoc, trustStorePassword)}, new SecureRandom());
            this.socketFactory = ctx.getSocketFactory();
        }
        catch (Exception ex) {
            logger.debug("Exception while creating SSL Context", (Throwable)ex);
        }
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.socketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.socketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(Socket socket, String string, int i, boolean bln) throws IOException {
        return this.socketFactory.createSocket(socket, string, i, bln);
    }

    @Override
    public Socket createSocket(String string, int i) throws IOException, UnknownHostException {
        return this.socketFactory.createSocket(string, i);
    }

    @Override
    public Socket createSocket(String string, int i, InetAddress ia, int i1) throws IOException, UnknownHostException {
        return this.socketFactory.createSocket(string, i, ia, i1);
    }

    @Override
    public Socket createSocket(InetAddress ia, int i) throws IOException {
        return this.socketFactory.createSocket(ia, i);
    }

    @Override
    public Socket createSocket(InetAddress ia, int i, InetAddress ia1, int i1) throws IOException {
        return this.socketFactory.createSocket(ia, i, ia1, i1);
    }
}

