/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ActiveDirectoryUUIDByteParser {
    public static String parseGUID(byte[] objectGUID) {
        return ActiveDirectoryUUIDByteParser.prefixZeros(objectGUID[3] & 0xFF) + ActiveDirectoryUUIDByteParser.prefixZeros(objectGUID[2] & 0xFF) + ActiveDirectoryUUIDByteParser.prefixZeros(objectGUID[1] & 0xFF) + ActiveDirectoryUUIDByteParser.prefixZeros(objectGUID[0] & 0xFF) + "-" + ActiveDirectoryUUIDByteParser.prefixZeros(objectGUID[5] & 0xFF) + ActiveDirectoryUUIDByteParser.prefixZeros(objectGUID[4] & 0xFF) + "-" + ActiveDirectoryUUIDByteParser.prefixZeros(objectGUID[7] & 0xFF) + ActiveDirectoryUUIDByteParser.prefixZeros(objectGUID[6] & 0xFF) + "-" + ActiveDirectoryUUIDByteParser.prefixZeros(objectGUID[8] & 0xFF) + ActiveDirectoryUUIDByteParser.prefixZeros(objectGUID[9] & 0xFF) + "-" + ActiveDirectoryUUIDByteParser.prefixZeros(objectGUID[10] & 0xFF) + ActiveDirectoryUUIDByteParser.prefixZeros(objectGUID[11] & 0xFF) + ActiveDirectoryUUIDByteParser.prefixZeros(objectGUID[12] & 0xFF) + ActiveDirectoryUUIDByteParser.prefixZeros(objectGUID[13] & 0xFF) + ActiveDirectoryUUIDByteParser.prefixZeros(objectGUID[14] & 0xFF) + ActiveDirectoryUUIDByteParser.prefixZeros(objectGUID[15] & 0xFF);
    }

    public static String parseSID(byte[] objectSid) {
        StringBuilder strSid = new StringBuilder("S-");
        byte revision = objectSid[0];
        strSid.append(Integer.toString(revision));
        int countSubAuths = objectSid[1] & 0xFF;
        long authority = 0L;
        for (int i = 2; i <= 7; ++i) {
            authority |= (long)objectSid[i] << 8 * (5 - (i - 2));
        }
        strSid.append("-");
        strSid.append(Long.toHexString(authority));
        int offset = 8;
        int size = 4;
        for (int j = 0; j < countSubAuths; ++j) {
            long subAuthority = 0L;
            for (int k = 0; k < size; ++k) {
                subAuthority |= (long)(objectSid[offset + k] & 0xFF) << 8 * k;
            }
            strSid.append("-");
            strSid.append(subAuthority);
            offset += size;
        }
        return strSid.toString();
    }

    private static String prefixZeros(int value) {
        if (value <= 15) {
            return "0" + Integer.toHexString(value);
        }
        return Integer.toHexString(value);
    }

    public static String replaceGUIDWithADCompliantArray(String objectGUID) {
        CharSequence[] array = ActiveDirectoryUUIDByteParser.convertMSGUIDToHexFormat(objectGUID).split("(?<=\\G.{2})");
        String result = "\\";
        result = result + String.join((CharSequence)"\\", array);
        return result;
    }

    public static String convertMSGUIDToHexFormat(String guid) {
        guid = guid.replace("-", "");
        guid = guid.replaceAll("(.{8})(.{4})(.{4})(.{4})(.{12})", "$1-$2-$3-$4-$5").replaceAll("(.{2})(.{2})(.{2})(.{2}).(.{2})(.{2}).(.{2})(.{2})(.{18})", "$4$3$2$1-$6$5-$8$7$9");
        guid = guid.replace("-", "");
        return guid;
    }

    public static String replaceFilterGUID(String filter) {
        String guid = "";
        Pattern p = Pattern.compile("[0-9A-Fa-f]{8}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{4}-[0-9A-Fa-f]{12}");
        Matcher m = p.matcher(filter);
        while (m.find()) {
            guid = m.group();
        }
        filter = filter.replace(guid, ActiveDirectoryUUIDByteParser.replaceGUIDWithADCompliantArray(guid));
        return filter;
    }
}

