/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.sources;

import java.io.Serializable;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.extension.ldap.api.model.SearchScope;
import org.mule.extension.ldap.internal.config.LDAPConfiguration;
import org.mule.extension.ldap.internal.connection.LDAPConnection;
import org.mule.extension.ldap.internal.error.LDAPErrorType;
import org.mule.extension.ldap.internal.error.exception.LDAPException;
import org.mule.extension.ldap.internal.metadata.LDAPEntryObjectClassMetadataResolver;
import org.mule.extension.ldap.internal.operation.SearchOperationParameters;
import org.mule.extension.ldap.internal.service.EntrySearchServiceImpl;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.PollContext;
import org.mule.runtime.extension.api.runtime.source.PollingSource;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;

public abstract class AbstractSource
extends PollingSource<Map<String, Object>, Serializable> {
    private static final DateTimeFormatter DATETIME_FORMAT = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
    private static final String DISTINGUISHED_NAME = "dn";
    private static final String SORT_KEY = "sortKey";
    private EntrySearchServiceImpl ldapServiceImpl;
    @Config
    private LDAPConfiguration configuration;
    @Connection
    private ConnectionProvider<LDAPConnection> connectionProvider;
    private LDAPConnection ldapConnection;
    @Parameter
    @DisplayName(value="Base DN")
    private String baseDn;
    @Parameter
    @DisplayName(value="Filter")
    @org.mule.runtime.extension.api.annotation.param.Optional
    private String filter;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @NullSafe
    protected List<String> attributes;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="ONE_LEVEL")
    private SearchScope scope;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @MetadataKeyId(value=LDAPEntryObjectClassMetadataResolver.class)
    private String structuralObjectClass;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    private String since;
    private boolean isActiveDirectory;

    public boolean isActiveDirectory() {
        return this.isActiveDirectory;
    }

    protected void doStart() throws MuleException {
        this.ldapConnection = (LDAPConnection)this.connectionProvider.connect();
        this.ldapServiceImpl = new EntrySearchServiceImpl(this.configuration, this.ldapConnection);
        this.attributes.add(this.getWatermarkField());
        SearchOperationParameters searchOperationParameters = new SearchOperationParameters.SearchOperationsParametersBuilder(this.baseDn, "(objectclass=*)", this.attributes, this.scope, false).setTimeout(0).setMaxResults(1L).setReturnObject(false).setPageSize(0).setStructuralObjectClass(this.structuralObjectClass).build();
        List<Map<String, Object>> searchResults = this.ldapServiceImpl.search(searchOperationParameters);
        if (searchResults != null && !searchResults.isEmpty() && (searchResults.get(0).keySet().contains("modifyTimeStamp") || searchResults.get(0).keySet().contains("createTimeStamp"))) {
            this.isActiveDirectory = true;
        }
        if (this.since == null || this.since.isEmpty()) {
            this.since = this.isActiveDirectory ? LocalDateTime.now(Clock.systemUTC()).format(DATETIME_FORMAT) + ".Z" : LocalDateTime.now(Clock.systemUTC()).format(DATETIME_FORMAT) + "Z";
        }
    }

    protected void doStop() {
        try {
            this.ldapConnection.disconnect();
        }
        catch (LDAPException e) {
            throw new ModuleException((ErrorTypeDefinition)LDAPErrorType.UNKNOWN, (Throwable)((Object)e));
        }
    }

    public void poll(PollContext<Map<String, Object>, Serializable> pollContext) {
        String searchFilter;
        String dateFilter = "(" + this.getWatermarkField() + ">=" + this.since + ")";
        Optional watermarkValue = pollContext.getWatermark();
        if (watermarkValue.isPresent()) {
            dateFilter = "(" + this.getWatermarkField() + ">=" + String.valueOf(watermarkValue.get()).split("\\|\\|")[0] + ")";
        }
        String string = searchFilter = StringUtils.isBlank((String)this.filter) ? dateFilter : "(&" + this.filter + dateFilter + ")";
        if (this.attributes == null) {
            this.attributes = new ArrayList<String>();
        }
        if (!this.attributes.contains(this.getWatermarkField())) {
            this.attributes.add(this.getWatermarkField());
        }
        try {
            SearchOperationParameters searchOperationParameters = new SearchOperationParameters.SearchOperationsParametersBuilder(this.baseDn, searchFilter, this.attributes, this.scope, false).setTimeout(0).setMaxResults(0L).setReturnObject(false).setPageSize(0).setStructuralObjectClass(this.structuralObjectClass).build();
            List<Map<String, Object>> searchResults = this.ldapServiceImpl.search(searchOperationParameters);
            searchResults.forEach(result -> result.put(SORT_KEY, result.get(this.getWatermarkField()) + "||" + result.get(DISTINGUISHED_NAME)));
            searchResults.sort(Comparator.comparing(o -> String.valueOf(o.get(SORT_KEY))));
            searchResults.forEach(result -> {
                String watermark = String.valueOf(result.remove(SORT_KEY));
                pollContext.accept(item -> item.setResult(this.toResult((Map<String, Object>)result)).setWatermark((Serializable)((Object)watermark)));
            });
        }
        catch (LDAPException e) {
            throw new ModuleException((ErrorTypeDefinition)LDAPErrorType.UNKNOWN, (Throwable)((Object)e));
        }
    }

    public void onRejectedItem(Result<Map<String, Object>, Serializable> result, SourceCallbackContext callbackContext) {
    }

    protected abstract String getWatermarkField();

    protected Result<Map<String, Object>, Serializable> toResult(Map<String, Object> entity) {
        return Result.builder().output(entity).build();
    }
}

