/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.service;

import java.util.Map;
import org.mule.connectors.commons.template.config.ConnectorConfig;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.connectors.commons.template.service.DefaultConnectorService;
import org.mule.extension.ldap.internal.config.LDAPConfiguration;
import org.mule.extension.ldap.internal.connection.LDAPConnection;
import org.mule.extension.ldap.internal.model.LDAPEntry;
import org.mule.extension.ldap.internal.service.LDIFConversionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDIFConversionServiceImpl
extends DefaultConnectorService<LDAPConfiguration, LDAPConnection>
implements LDIFConversionService {
    private static final Logger logger = LoggerFactory.getLogger(LDIFConversionServiceImpl.class);

    public LDIFConversionServiceImpl(LDAPConfiguration config, LDAPConnection ldapConnection) {
        super((ConnectorConfig)config, (ConnectorConnection)ldapConnection);
    }

    @Override
    public String ldapEntryToLdif(Map<String, Object> entry) {
        try {
            return entry != null ? LDAPEntry.getInstanceFromMap(entry).toLDIFString() : null;
        }
        catch (Exception e) {
            logger.warn("Error while executing ldapEntryToLdif operation : {}", (Object)e.getMessage());
            throw e;
        }
    }
}

