/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.service;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.mule.connectors.commons.template.config.ConnectorConfig;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.connectors.commons.template.service.DefaultConnectorService;
import org.mule.extension.ldap.internal.config.LDAPConfiguration;
import org.mule.extension.ldap.internal.connection.LDAPConnection;
import org.mule.extension.ldap.internal.error.LDAPErrorType;
import org.mule.extension.ldap.internal.error.exception.LDAPException;
import org.mule.extension.ldap.internal.model.LDAPEntry;
import org.mule.extension.ldap.internal.model.LDAPEntryAttribute;
import org.mule.extension.ldap.internal.model.LDAPMultiValueEntryAttribute;
import org.mule.extension.ldap.internal.model.LDAPSingleValueEntryAttribute;
import org.mule.extension.ldap.internal.service.EntryService;
import org.mule.extension.ldap.internal.service.LDIFConversionServiceImpl;
import org.mule.extension.ldap.internal.util.LDAPJNDIUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryServiceImpl
extends DefaultConnectorService<LDAPConfiguration, LDAPConnection>
implements EntryService {
    private static final String OBJECT_CLASS_ATTR_NAME = "objectClass";
    private static final Logger logger = LoggerFactory.getLogger(LDIFConversionServiceImpl.class);

    public EntryServiceImpl(LDAPConfiguration config, LDAPConnection ldapConnection) {
        super((ConnectorConfig)config, (ConnectorConnection)ldapConnection);
    }

    @Override
    public void add(Map<String, Object> entry, String structuralObjectClass) {
        try {
            LDAPEntry ldapEntry = LDAPEntry.getInstanceFromMap(entry);
            String dn = ldapEntry.getDn();
            if (dn != null) {
                ldapEntry.setDn(LDAPJNDIUtils.escapeMetaCharacters(dn));
            }
            this.processObjectClass(ldapEntry, structuralObjectClass);
            logger.debug("About to add entry {}: {}", (Object)ldapEntry.getDn(), entry);
            ((LDAPConnection)this.getConnection()).addEntry(ldapEntry);
            logger.info("Added entry {}", (Object)ldapEntry.getDn());
        }
        catch (Exception e) {
            logger.warn("Error while executing add operation : {}", (Object)e.getMessage());
            throw e;
        }
    }

    private void processObjectClass(@NotNull LDAPEntry entry, String structuralObjectClass) {
        LDAPEntryAttribute objectClassAttribute = entry.getAttribute(OBJECT_CLASS_ATTR_NAME);
        if (objectClassAttribute != null) {
            List<Object> objectClasses = objectClassAttribute.getValues();
            if (!objectClasses.contains(structuralObjectClass)) {
                logger.warn("Entry {} does not contain the specified structural objectClass {}. Defined objectClasses are: {}", new Object[]{entry.getDn(), structuralObjectClass, objectClasses});
            }
        } else {
            logger.debug("Entry {} does not contain objectClass attribute. Setting objectClasses based on {} hierarchy", (Object)entry.getDn(), (Object)structuralObjectClass);
            try {
                List<String> objectClasses = ((LDAPConnection)this.getConnection()).getMetaDataBuilder().getObjectClassHierarchyFor(structuralObjectClass);
                logger.debug("Setting objectClass values {} to entry {}", objectClasses, (Object)entry.getDn());
                entry.addAttribute(OBJECT_CLASS_ATTR_NAME, objectClasses);
            }
            catch (LDAPException ex) {
                logger.warn("Could not retrieve objectClass hierarchy for " + structuralObjectClass, (Throwable)((Object)ex));
            }
        }
    }

    @Override
    public void modify(Map<String, Object> entry, String structuralObjectClass) {
        try {
            LDAPEntry ldapEntry = LDAPEntry.getInstanceFromMap(entry);
            logger.debug("About to modify entry {}: {}", (Object)ldapEntry.getDn(), entry);
            ((LDAPConnection)this.getConnection()).updateEntry(ldapEntry);
            logger.info("Modified entry {}", (Object)ldapEntry.getDn());
        }
        catch (Exception e) {
            logger.warn("Error while executing modify operation : {}", (Object)e.getMessage());
            throw e;
        }
    }

    @Override
    public void delete(String dn) {
        try {
            logger.debug("About to delete entry {}", (Object)dn);
            ((LDAPConnection)this.getConnection()).deleteEntry(dn);
            logger.info("Deleted entry {}", (Object)dn);
        }
        catch (Exception e) {
            logger.warn("Error while executing delete operation : {}", (Object)e.getMessage());
            throw e;
        }
    }

    @Override
    public void rename(String oldDn, String newDn) {
        try {
            logger.debug("About to rename entry {} to {}", (Object)oldDn, (Object)newDn);
            ((LDAPConnection)this.getConnection()).renameEntry(oldDn, newDn);
            logger.info("Renamed entry {} to {}", (Object)oldDn, (Object)newDn);
        }
        catch (Exception e) {
            logger.warn("Error while executing rename operation : {}", (Object)e.getMessage());
            throw e;
        }
    }

    @Override
    public void addSingleValueAttribute(String dn, String attributeName, String attributeValue, boolean ignoreInvalidAttribute) {
        try {
            logger.debug("About to add attribute {} with value {} to entry {}", new Object[]{attributeName, attributeValue, dn});
            ((LDAPConnection)this.getConnection()).addAttribute(dn, new LDAPSingleValueEntryAttribute(attributeName, attributeValue));
            logger.info("Added attribute {} with value {} to entry {}", new Object[]{attributeName, attributeValue, dn});
        }
        catch (Exception e) {
            this.handleException(e, "addSingleValueAttribute", "addition", ignoreInvalidAttribute);
        }
    }

    @Override
    public void addMultiValueAttribute(String dn, String attributeName, List<Object> attributeValues, boolean ignoreInvalidAttribute) {
        try {
            logger.debug("About to add attribute {} with values {} to entry {}", new Object[]{attributeName, attributeValues, dn});
            ((LDAPConnection)this.getConnection()).addAttribute(dn, new LDAPMultiValueEntryAttribute(attributeName, attributeValues));
            logger.info("Added attribute {} with values {} to entry {}", new Object[]{attributeName, attributeValues, dn});
        }
        catch (Exception e) {
            this.handleException(e, "addMultiValueAttribute", "addition", ignoreInvalidAttribute);
        }
    }

    @Override
    public void modifySingleValueAttribute(String dn, String attributeName, String attributeValue, boolean ignoreInvalidAttribute) {
        try {
            logger.debug("About to update attribute {} with value {} to entry {}", new Object[]{attributeName, attributeValue, dn});
            ((LDAPConnection)this.getConnection()).updateAttribute(dn, new LDAPSingleValueEntryAttribute(attributeName, attributeValue));
            logger.info("Updated attribute {} with value {} to entry {}", new Object[]{attributeName, attributeValue, dn});
        }
        catch (Exception e) {
            this.handleException(e, "modifySingleValueAttribute", "modification", ignoreInvalidAttribute);
        }
    }

    @Override
    public void modifyMultiValueAttribute(String dn, String attributeName, List<Object> attributeValues, boolean ignoreInvalidAttribute) {
        try {
            logger.debug("About to modify attribute {} with values {} to entry {}", new Object[]{attributeName, attributeValues, dn});
            ((LDAPConnection)this.getConnection()).updateAttribute(dn, new LDAPMultiValueEntryAttribute(attributeName, attributeValues));
            logger.info("Modified attribute {} with values {} to entry {}", new Object[]{attributeName, attributeValues, dn});
        }
        catch (Exception e) {
            this.handleException(e, "modifyMultiValueAttribute", "modification", ignoreInvalidAttribute);
        }
    }

    @Override
    public void deleteSingleValueAttribute(String dn, String attributeName, String attributeValue, boolean ignoreInvalidAttribute) {
        try {
            logger.debug("About to delete value {} from attribute {} on entry {}", new Object[]{attributeValue, attributeName, dn});
            ((LDAPConnection)this.getConnection()).deleteAttribute(dn, new LDAPSingleValueEntryAttribute(attributeName, attributeValue));
            if (attributeValue != null && attributeValue.length() > 0) {
                logger.info("Deleted value {} from attribute {} from entry {}", new Object[]{attributeValue, attributeName, dn});
            } else {
                logger.info("Deleted attribute {} from entry {}", (Object)attributeName, (Object)dn);
            }
        }
        catch (Exception e) {
            this.handleException(e, "deleteSingleValueAttribute", "deletion", ignoreInvalidAttribute);
        }
    }

    @Override
    public void deleteMultiValueAttribute(String dn, String attributeName, List<Object> attributeValues, boolean ignoreInvalidAttribute) {
        try {
            logger.debug("About to delete values {} from attribute {} on entry {}", new Object[]{attributeValues, attributeName, dn});
            ((LDAPConnection)this.getConnection()).deleteAttribute(dn, new LDAPMultiValueEntryAttribute(attributeName, attributeValues));
            logger.info("Deleted values {} from attribute {} on entry {}", new Object[]{attributeValues, attributeName, dn});
        }
        catch (Exception e) {
            this.handleException(e, "deleteMultiValueAttribute", "deletion", ignoreInvalidAttribute);
        }
    }

    private void handleException(Exception ex, String operationName, String methodToken, boolean ignoreInvalidAttributes) {
        if (ex instanceof LDAPException) {
            LDAPException ldapException = (LDAPException)((Object)ex);
            if (!ignoreInvalidAttributes) {
                logger.warn("Error while executing {} operation : {}", (Object)operationName, (Object)ldapException.getMessage());
                throw ldapException;
            }
            if (ldapException.getType().equals((Object)LDAPErrorType.INVALID_ATTRIBUTE)) {
                logger.info("Ignoring attribute {} : {}", (Object)methodToken, (Object)ldapException.getMessage());
            }
        } else {
            logger.warn("Error while executing {} operation : {}", (Object)operationName, (Object)ex.getMessage());
            throw new RuntimeException(ex);
        }
    }
}

