/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.mule.connectors.commons.template.config.ConnectorConfig;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.connectors.commons.template.service.DefaultConnectorService;
import org.mule.extension.ldap.internal.config.LDAPConfiguration;
import org.mule.extension.ldap.internal.connection.LDAPConnection;
import org.mule.extension.ldap.internal.error.exception.LDAPException;
import org.mule.extension.ldap.internal.model.LDAPEntry;
import org.mule.extension.ldap.internal.model.LDAPSearchControls;
import org.mule.extension.ldap.internal.model.LDAPSingleValueEntryAttribute;
import org.mule.extension.ldap.internal.model.LDAPSortKey;
import org.mule.extension.ldap.internal.operation.SearchOperationParameters;
import org.mule.extension.ldap.internal.operation.paging.LDAPEntryPagingProvider;
import org.mule.extension.ldap.internal.service.EntrySearchService;
import org.mule.extension.ldap.internal.service.LDIFConversionServiceImpl;
import org.mule.extension.ldap.internal.util.ActiveDirectoryUUIDByteParser;
import org.mule.extension.ldap.internal.util.LDAPResultSet;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntrySearchServiceImpl
extends DefaultConnectorService<LDAPConfiguration, LDAPConnection>
implements EntrySearchService {
    private static final Logger logger = LoggerFactory.getLogger(LDIFConversionServiceImpl.class);
    public static final String OBJECT_GUID = "objectGUID";
    public static final String OBJECT_SID = "objectSid";

    public EntrySearchServiceImpl(LDAPConfiguration config, LDAPConnection ldapConnection) {
        super((ConnectorConfig)config, (ConnectorConnection)ldapConnection);
    }

    @Override
    public Map<String, Object> lookup(String dn, List<String> attributes, String structuralObjectClass, boolean showAttributesAsObjects) {
        LDAPEntry entry;
        try {
            logger.debug("About to retrieve LDAP entry: {}", (Object)dn);
            entry = attributes != null && !attributes.isEmpty() ? ((LDAPConnection)this.getConnection()).lookup(dn, attributes.toArray(new String[attributes.size()])) : ((LDAPConnection)this.getConnection()).lookup(dn);
            logger.debug("Retrieved entry: {}", (Object)entry);
            if (attributes != null && !attributes.isEmpty() && !attributes.contains("dn")) {
                entry.setDn(null);
            }
        }
        catch (Exception e) {
            logger.warn("Error while executing lookup operation : {}", (Object)e.getMessage());
            throw e;
        }
        if (showAttributesAsObjects) {
            return entry;
        }
        return entry.toMap();
    }

    @Override
    public boolean exists(String dn) {
        boolean entryExists = false;
        try {
            this.lookup(dn, null, null, false);
            entryExists = true;
        }
        catch (LDAPException le) {
            logger.warn("DN not found.", (Throwable)((Object)le));
            logger.warn("Error while executing exists operation : {}", (Object)le.getMessage());
        }
        return entryExists;
    }

    @Override
    public List<Map<String, Object>> search(SearchOperationParameters searchOperationParameters) {
        try (LDAPResultSet result = null;){
            logger.debug("About to search LDAP entries matching {} under: {} ", (Object)searchOperationParameters.getFilter(), (Object)searchOperationParameters.getBaseDn());
            LDAPSearchControls controls = new LDAPSearchControls();
            if (searchOperationParameters.getAttributes() != null && !searchOperationParameters.getAttributes().isEmpty()) {
                controls.setAttributesToReturn(searchOperationParameters.getAttributes().toArray(new String[searchOperationParameters.getAttributes().size()]));
            }
            controls.setMaxResults(searchOperationParameters.getMaxResults());
            controls.setTimeout(searchOperationParameters.getTimeout());
            controls.setScope(searchOperationParameters.getScope());
            controls.setReturnObject(searchOperationParameters.isReturnObject());
            controls.setPageSize(searchOperationParameters.getPageSize());
            result = ((LDAPConnection)this.getConnection()).search(searchOperationParameters.getBaseDn(), searchOperationParameters.getFilter(), controls);
            if (searchOperationParameters.isShowAttributesAsObjects()) {
                ArrayList<Map<String, Object>> allEntries = new ArrayList<Map<String, Object>>(result.getAllEntries());
                this.iterateAndFilterEntriesForObjectGuidOrSid(allEntries);
                logger.debug("Retrieved {} entries", (Object)allEntries.size());
                ArrayList<Map<String, Object>> arrayList = allEntries;
                return arrayList;
            }
            List<LDAPEntry> allEntries = result.getAllEntries();
            allEntries.forEach(ldapEntry -> {
                Optional.ofNullable(ldapEntry.getAttribute(OBJECT_SID)).ifPresent(ldapEntryAttribute -> ldapEntry.addAttribute(OBJECT_SID, ActiveDirectoryUUIDByteParser.parseSID((byte[])ldapEntryAttribute.getValue())));
                Optional.ofNullable(ldapEntry.getAttribute(OBJECT_GUID)).ifPresent(ldapEntryAttribute -> ldapEntry.addAttribute(OBJECT_GUID, ActiveDirectoryUUIDByteParser.parseGUID((byte[])ldapEntryAttribute.getValue())));
            });
            logger.debug("Retrieved {} entries", (Object)allEntries.size());
            List<Map<String, Object>> list = LDAPEntry.getListOfMaps(allEntries);
            return list;
        }
    }

    private void iterateAndFilterEntriesForObjectGuidOrSid(List<Map<String, Object>> allEntries) {
        allEntries.forEach(entity -> {
            entity.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(OBJECT_GUID)).forEach(this.replaceObjectGuidValueWithStringCorrespondent((Map<String, Object>)entity, OBJECT_GUID));
            entity.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals(OBJECT_SID)).forEach(this.replaceObjectGuidValueWithStringCorrespondent((Map<String, Object>)entity, OBJECT_SID));
        });
    }

    private Consumer<Map.Entry<String, Object>> replaceObjectGuidValueWithStringCorrespondent(Map<String, Object> entity, String attributeType) {
        if (attributeType.equals(OBJECT_GUID)) {
            return guidEntry -> entity.replace(attributeType, new LDAPSingleValueEntryAttribute(attributeType, ActiveDirectoryUUIDByteParser.parseGUID((byte[])((LDAPSingleValueEntryAttribute)guidEntry.getValue()).getValue())));
        }
        return guidEntry -> entity.replace(attributeType, new LDAPSingleValueEntryAttribute(attributeType, ActiveDirectoryUUIDByteParser.parseSID((byte[])((LDAPSingleValueEntryAttribute)guidEntry.getValue()).getValue())));
    }

    @Override
    public PagingProvider<LDAPConnection, Map<String, Object>> pagedResultSearch(SearchOperationParameters searchOperationParameters, String orderBy, boolean ascending, int fetchSize) {
        try {
            logger.debug("About to search LDAP entries matching {} under: {}. Returning results in pages of {} entries.", new Object[]{searchOperationParameters.getFilter(), searchOperationParameters.getBaseDn(), searchOperationParameters.getPageSize()});
            LDAPSearchControls controls = new LDAPSearchControls();
            if (searchOperationParameters.getAttributes() != null && !searchOperationParameters.getAttributes().isEmpty()) {
                controls.setAttributesToReturn(searchOperationParameters.getAttributes().toArray(new String[searchOperationParameters.getAttributes().size()]));
            }
            controls.setMaxResults(searchOperationParameters.getMaxResults());
            controls.setTimeout(searchOperationParameters.getTimeout());
            controls.setScope(searchOperationParameters.getScope());
            controls.setReturnObject(searchOperationParameters.isReturnObject());
            controls.setPageSize(searchOperationParameters.getPageSize());
            if (StringUtils.isNotBlank((String)orderBy)) {
                controls.getSortKeys().add(new LDAPSortKey(orderBy, ascending, null));
            }
            return new LDAPEntryPagingProvider(searchOperationParameters.getBaseDn(), searchOperationParameters.getFilter(), controls, fetchSize, searchOperationParameters.isShowAttributesAsObjects());
        }
        catch (Exception e) {
            logger.warn("Error while executing pagedResultSearch operation : {}", (Object)e.getMessage());
            throw e;
        }
    }

    @Override
    public Map<String, Object> searchOne(SearchOperationParameters searchOperationParameters) {
        List<Map<String, Object>> results;
        try {
            logger.debug("Searching entries under {} with filter {}", (Object)searchOperationParameters.getBaseDn(), (Object)searchOperationParameters.getFilter());
            results = this.search(searchOperationParameters);
            if (results != null && results.size() > 1) {
                logger.warn("Search returned more than one result. Total results matching filter [{}]: {} ", (Object)searchOperationParameters.getFilter(), (Object)results.size());
            }
        }
        catch (Exception e) {
            logger.warn("Error while executing searchOne operation : {}", (Object)e.getMessage());
            throw e;
        }
        return results != null && !results.isEmpty() ? results.get(0) : null;
    }
}

