/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.operation.paging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.extension.ldap.internal.connection.LDAPConnection;
import org.mule.extension.ldap.internal.model.LDAPSearchControls;
import org.mule.extension.ldap.internal.util.LDAPResultSet;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDAPEntryPagingProvider
implements PagingProvider<LDAPConnection, Map<String, Object>> {
    private static final Logger logger = LoggerFactory.getLogger((String)LDAPEntryPagingProvider.class.getName());
    private LDAPResultSet rs;
    private int fetchSize;
    private String baseDn;
    private String filter;
    private LDAPSearchControls controls;
    private boolean resultSetObtained = false;
    private boolean showAttributesAsObjects = false;

    public LDAPEntryPagingProvider(String baseDn, String filter, LDAPSearchControls controls, int fetchSize, boolean showAttributesAsObjects) {
        this.baseDn = baseDn;
        this.filter = filter;
        this.controls = controls;
        this.fetchSize = fetchSize;
        this.showAttributesAsObjects = showAttributesAsObjects;
    }

    public void close(LDAPConnection ldapConnection) {
        if (this.rs != null) {
            this.rs.close();
            this.rs = null;
            ldapConnection.disconnect();
        }
    }

    public Optional<Integer> getTotalResults(LDAPConnection ldapConnection) {
        if (this.rs != null) {
            return Optional.of(this.rs.getResultSize());
        }
        logger.info("Result set was null, bad connection or no results.");
        return Optional.of(0);
    }

    public List<Map<String, Object>> getPage(LDAPConnection ldapConnection) {
        if (!this.resultSetObtained) {
            this.rs = ldapConnection.search(this.baseDn, this.filter, this.controls);
            this.resultSetObtained = true;
        }
        if (!this.rs.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> pageElements = new ArrayList<Map<String, Object>>(this.fetchSize);
        for (int count = 0; this.rs.hasNext() && count < this.fetchSize; ++count) {
            if (this.showAttributesAsObjects) {
                pageElements.add(this.rs.next());
                continue;
            }
            pageElements.add(this.rs.next().toMap());
        }
        return pageElements;
    }
}

