/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.operation;

import java.util.List;
import java.util.Map;
import org.mule.connectors.atlantic.commons.builder.execution.ExecutionBuilder;
import org.mule.connectors.commons.template.config.ConnectorConfig;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.connectors.commons.template.operation.ConnectorOperations;
import org.mule.extension.ldap.api.model.SearchScope;
import org.mule.extension.ldap.internal.config.LDAPConfiguration;
import org.mule.extension.ldap.internal.connection.LDAPConnection;
import org.mule.extension.ldap.internal.error.LDAPErrorType;
import org.mule.extension.ldap.internal.error.exception.LDAPException;
import org.mule.extension.ldap.internal.error.provider.LDAPErrorTypeProvider;
import org.mule.extension.ldap.internal.metadata.LDAPEntryObjectClassMetadataResolver;
import org.mule.extension.ldap.internal.operation.SearchOperationParameters;
import org.mule.extension.ldap.internal.service.EntrySearchService;
import org.mule.extension.ldap.internal.service.EntrySearchServiceImpl;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;

@Throws(value={LDAPErrorTypeProvider.class})
public class EntrySearchOperations
extends ConnectorOperations<LDAPConfiguration, LDAPConnection, EntrySearchService> {
    public EntrySearchOperations() {
        super(EntrySearchServiceImpl::new);
    }

    @OutputResolver(output=LDAPEntryObjectClassMetadataResolver.class)
    public Map<String, Object> lookup(@Config LDAPConfiguration configuration, @Connection LDAPConnection ldapConnection, @DisplayName(value="DN") String dn, @Optional @NullSafe List<String> attributes, @MetadataKeyId(value=LDAPEntryObjectClassMetadataResolver.class) @Optional(defaultValue="") String structuralObjectClass) {
        return (Map)this.newExecutionBuilder(configuration, ldapConnection).execute(EntrySearchService::lookup).withParam((Object)dn).withParam(attributes).withParam((Object)structuralObjectClass).withParam((Object)configuration.isShowAttributesAsObjects());
    }

    public boolean exists(@Config LDAPConfiguration configuration, @Connection LDAPConnection ldapConnection, @DisplayName(value="DN") String dn) {
        return (Boolean)this.newExecutionBuilder(configuration, ldapConnection).execute(EntrySearchService::exists).withParam((Object)dn);
    }

    @OutputResolver(output=LDAPEntryObjectClassMetadataResolver.class)
    public List<Map<String, Object>> search(@Config LDAPConfiguration configuration, @Connection LDAPConnection ldapConnection, @DisplayName(value="Base DN") String baseDn, String filter, @Optional @NullSafe List<String> attributes, @Optional(defaultValue="ONE_LEVEL") SearchScope scope, @Placement(tab="Search Controls") @Optional(defaultValue="0") int timeout, @Placement(tab="Search Controls") @Optional(defaultValue="0") long maxResults, @Placement(tab="Search Controls") @Optional(defaultValue="false") boolean returnObject, @Placement(tab="Search Controls") @Optional(defaultValue="0") int pageSize, @MetadataKeyId(value=LDAPEntryObjectClassMetadataResolver.class) @Optional(defaultValue="") String structuralObjectClass) {
        SearchOperationParameters searchOperationParameters = new SearchOperationParameters.SearchOperationsParametersBuilder(baseDn, filter, attributes, scope, configuration.isShowAttributesAsObjects()).setTimeout(timeout).setMaxResults(maxResults).setReturnObject(returnObject).setPageSize(pageSize).setStructuralObjectClass(structuralObjectClass).build();
        return (List)this.newExecutionBuilder(configuration, ldapConnection).execute(EntrySearchService::search).withParam((Object)searchOperationParameters);
    }

    @OutputResolver(output=LDAPEntryObjectClassMetadataResolver.class)
    public PagingProvider<LDAPConnection, Map<String, Object>> pagedResultSearch(@Config LDAPConfiguration configuration, @DisplayName(value="Base DN") String baseDn, String filter, @Optional @NullSafe List<String> attributes, @Optional(defaultValue="ONE_LEVEL") SearchScope scope, @Placement(tab="Search Controls") @Optional(defaultValue="0") int timeout, @Placement(tab="Search Controls") @Optional(defaultValue="0") long maxResults, @Placement(tab="Search Controls") @Optional(defaultValue="false") boolean returnObject, @Placement(tab="Search Controls") @Optional(defaultValue="0") int pageSize, @DisplayName(value="Order by attribute") @Placement(tab="Search Controls", order=1) @Optional String orderBy, @DisplayName(value="Ascending order?") @Placement(tab="Search Controls", order=2) @Optional(defaultValue="true") boolean ascending, @MetadataKeyId(value=LDAPEntryObjectClassMetadataResolver.class) @Optional(defaultValue="") String structuralObjectClass, @Optional(defaultValue="200") int fetchSize) {
        SearchOperationParameters searchOperationParameters = new SearchOperationParameters.SearchOperationsParametersBuilder(baseDn, filter, attributes, scope, configuration.isShowAttributesAsObjects()).setTimeout(timeout).setMaxResults(maxResults).setReturnObject(returnObject).setPageSize(pageSize).setStructuralObjectClass(structuralObjectClass).build();
        return (PagingProvider)this.newExecutionBuilder(configuration, (LDAPConnection)null).execute(EntrySearchService::pagedResultSearch).withParam((Object)searchOperationParameters).withParam((Object)orderBy).withParam((Object)ascending).withParam((Object)fetchSize);
    }

    @OutputResolver(output=LDAPEntryObjectClassMetadataResolver.class)
    public Map<String, Object> searchOne(@Config LDAPConfiguration configuration, @Connection LDAPConnection ldapConnection, @DisplayName(value="Base DN") String baseDn, String filter, @Optional @NullSafe List<String> attributes, @Optional(defaultValue="ONE_LEVEL") SearchScope scope, @Placement(tab="Search Controls") @Optional(defaultValue="0") int timeout, @Placement(tab="Search Controls") @Optional(defaultValue="0") long maxResults, @Placement(tab="Search Controls") @Optional(defaultValue="false") boolean returnObject, @MetadataKeyId(value=LDAPEntryObjectClassMetadataResolver.class) @Optional(defaultValue="") String structuralObjectClass) {
        SearchOperationParameters searchOperationParameters = new SearchOperationParameters.SearchOperationsParametersBuilder(baseDn, filter, attributes, scope, configuration.isShowAttributesAsObjects()).setTimeout(timeout).setMaxResults(maxResults).setReturnObject(returnObject).setPageSize(0).setStructuralObjectClass(structuralObjectClass).build();
        return (Map)this.newExecutionBuilder(configuration, ldapConnection).execute(EntrySearchService::searchOne).withParam((Object)searchOperationParameters);
    }

    protected ExecutionBuilder<EntrySearchService> newExecutionBuilder(LDAPConfiguration config, LDAPConnection connection) {
        return (ExecutionBuilder)((ExecutionBuilder)((ExecutionBuilder)super.newExecutionBuilder((ConnectorConfig)config, (ConnectorConnection)connection).withExceptionHandler(Exception.class, exception -> {
            throw new LDAPException(LDAPErrorType.UNKNOWN, exception);
        })).withExceptionHandler(LDAPException.class, exception -> {
            throw exception;
        })).withExceptionHandler(ConnectionException.class, exception -> {
            throw new LDAPException(exception.getMessage(), LDAPErrorType.CONNECTIVITY, exception);
        });
    }
}

