/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.operation;

import java.util.List;
import java.util.Map;
import org.mule.connectors.atlantic.commons.builder.execution.ExecutionBuilder;
import org.mule.connectors.commons.template.config.ConnectorConfig;
import org.mule.connectors.commons.template.connection.ConnectorConnection;
import org.mule.connectors.commons.template.operation.ConnectorOperations;
import org.mule.extension.ldap.internal.config.LDAPConfiguration;
import org.mule.extension.ldap.internal.connection.LDAPConnection;
import org.mule.extension.ldap.internal.error.LDAPErrorType;
import org.mule.extension.ldap.internal.error.exception.LDAPException;
import org.mule.extension.ldap.internal.error.provider.LDAPErrorTypeProvider;
import org.mule.extension.ldap.internal.metadata.LDAPEntryObjectClassMetadataResolver;
import org.mule.extension.ldap.internal.service.EntryService;
import org.mule.extension.ldap.internal.service.EntryServiceImpl;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

@Throws(value={LDAPErrorTypeProvider.class})
public class EntryOperations
extends ConnectorOperations<LDAPConfiguration, LDAPConnection, EntryService> {
    public EntryOperations() {
        super(EntryServiceImpl::new);
    }

    @DisplayName(value="Add entry")
    public void add(@Config LDAPConfiguration configuration, @Connection LDAPConnection ldapConnection, @Content @TypeResolver(value=LDAPEntryObjectClassMetadataResolver.class) Map<String, Object> entry, @MetadataKeyId(value=LDAPEntryObjectClassMetadataResolver.class) @Optional String structuralObjectClass) {
        this.newExecutionBuilder(configuration, ldapConnection).execute(EntryService::add).withParam(entry).withParam((Object)structuralObjectClass);
    }

    @DisplayName(value="Modify entry")
    public void modify(@Config LDAPConfiguration configuration, @Connection LDAPConnection ldapConnection, @Content @TypeResolver(value=LDAPEntryObjectClassMetadataResolver.class) Map<String, Object> entry, @MetadataKeyId(value=LDAPEntryObjectClassMetadataResolver.class) @Optional String structuralObjectClass) {
        this.newExecutionBuilder(configuration, ldapConnection).execute(EntryService::modify).withParam(entry).withParam((Object)structuralObjectClass);
    }

    @DisplayName(value="Delete entry")
    public void delete(@Config LDAPConfiguration configuration, @Connection LDAPConnection ldapConnection, @DisplayName(value="DN") String dn) {
        this.newExecutionBuilder(configuration, ldapConnection).execute(EntryService::delete).withParam((Object)dn);
    }

    @DisplayName(value="Rename entry")
    public void rename(@Config LDAPConfiguration configuration, @Connection LDAPConnection ldapConnection, @Placement(order=1) @DisplayName(value="Current DN") String oldDn, @Placement(order=2) @DisplayName(value="New DN") String newDn) {
        this.newExecutionBuilder(configuration, ldapConnection).execute(EntryService::rename).withParam((Object)oldDn).withParam((Object)newDn);
    }

    public void addSingleValueAttribute(@Config LDAPConfiguration configuration, @Connection LDAPConnection ldapConnection, @DisplayName(value="DN") String dn, String attributeName, String attributeValue, @Optional(defaultValue="false") boolean ignoreInvalidAttribute) {
        this.newExecutionBuilder(configuration, ldapConnection).execute(EntryService::addSingleValueAttribute).withParam((Object)dn).withParam((Object)attributeName).withParam((Object)attributeValue).withParam((Object)ignoreInvalidAttribute);
    }

    public void addMultiValueAttribute(@Config LDAPConfiguration configuration, @Connection LDAPConnection ldapConnection, @DisplayName(value="DN") String dn, String attributeName, @Content List<Object> attributeValues, @Optional(defaultValue="false") boolean ignoreInvalidAttribute) {
        this.newExecutionBuilder(configuration, ldapConnection).execute(EntryService::addMultiValueAttribute).withParam((Object)dn).withParam((Object)attributeName).withParam(attributeValues).withParam((Object)ignoreInvalidAttribute);
    }

    public void modifySingleValueAttribute(@Config LDAPConfiguration configuration, @Connection LDAPConnection ldapConnection, @DisplayName(value="DN") String dn, String attributeName, String attributeValue, @Optional(defaultValue="false") boolean ignoreInvalidAttribute) {
        this.newExecutionBuilder(configuration, ldapConnection).execute(EntryService::modifySingleValueAttribute).withParam((Object)dn).withParam((Object)attributeName).withParam((Object)attributeValue).withParam((Object)ignoreInvalidAttribute);
    }

    public void modifyMultiValueAttribute(@Config LDAPConfiguration configuration, @Connection LDAPConnection ldapConnection, @DisplayName(value="DN") String dn, String attributeName, @Content List<Object> attributeValues, @Optional(defaultValue="false") boolean ignoreInvalidAttribute) {
        this.newExecutionBuilder(configuration, ldapConnection).execute(EntryService::modifyMultiValueAttribute).withParam((Object)dn).withParam((Object)attributeName).withParam(attributeValues).withParam((Object)ignoreInvalidAttribute);
    }

    public void deleteSingleValueAttribute(@Config LDAPConfiguration configuration, @Connection LDAPConnection ldapConnection, @DisplayName(value="DN") String dn, String attributeName, @Optional String attributeValue, @Optional(defaultValue="false") boolean ignoreInvalidAttribute) {
        this.newExecutionBuilder(configuration, ldapConnection).execute(EntryService::deleteSingleValueAttribute).withParam((Object)dn).withParam((Object)attributeName).withParam((Object)attributeValue).withParam((Object)ignoreInvalidAttribute);
    }

    public void deleteMultiValueAttribute(@Config LDAPConfiguration configuration, @Connection LDAPConnection ldapConnection, @DisplayName(value="DN") String dn, String attributeName, @Content List<Object> attributeValues, @Optional(defaultValue="false") boolean ignoreInvalidAttribute) {
        this.newExecutionBuilder(configuration, ldapConnection).execute(EntryService::deleteMultiValueAttribute).withParam((Object)dn).withParam((Object)attributeName).withParam(attributeValues).withParam((Object)ignoreInvalidAttribute);
    }

    protected ExecutionBuilder<EntryService> newExecutionBuilder(LDAPConfiguration config, LDAPConnection connection) {
        return (ExecutionBuilder)((ExecutionBuilder)((ExecutionBuilder)super.newExecutionBuilder((ConnectorConfig)config, (ConnectorConnection)connection).withExceptionHandler(Exception.class, exception -> {
            throw new LDAPException(LDAPErrorType.UNKNOWN, exception);
        })).withExceptionHandler(LDAPException.class, exception -> {
            throw exception;
        })).withExceptionHandler(ConnectionException.class, exception -> {
            throw new LDAPException(exception.getMessage(), LDAPErrorType.CONNECTIVITY, exception);
        });
    }
}

