/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.model.datasense;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class SyntaxObjectIdentifier {
    private String oid = null;
    private boolean humanReadable = true;
    private String description = null;
    private static final Map<String, SyntaxObjectIdentifier> SYNTAX_OBJECT_IDENTIFIERS = new HashMap<String, SyntaxObjectIdentifier>(60);

    public SyntaxObjectIdentifier(String oid) {
        if (oid == null) {
            throw new IllegalArgumentException("oid cannot be null");
        }
        this.setOid(oid);
    }

    public SyntaxObjectIdentifier(String description, boolean humanReadable, String oid) {
        this(oid);
        this.setHumanReadable(humanReadable);
        this.setDescription(description);
    }

    public String getOid() {
        return this.oid;
    }

    private void setOid(String oid) {
        this.oid = oid;
    }

    public boolean isHumanReadable() {
        return this.humanReadable;
    }

    private void setHumanReadable(boolean humanReadable) {
        this.humanReadable = humanReadable;
    }

    public String getDescription() {
        return this.description;
    }

    private void setDescription(String description) {
        this.description = description;
    }

    public int hashCode() {
        return this.getOid().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SyntaxObjectIdentifier)) {
            return false;
        }
        SyntaxObjectIdentifier other = (SyntaxObjectIdentifier)obj;
        return this.getOid().equals(other.getOid());
    }

    public String toString() {
        return this.getDescription() != null ? this.getDescription() + " (" + this.getOid() + ")" : this.getOid();
    }

    private static void addSyntaxObjectIdentifier(SyntaxObjectIdentifier syntaxObjectIdentifier) {
        SYNTAX_OBJECT_IDENTIFIERS.put(syntaxObjectIdentifier.getOid(), syntaxObjectIdentifier);
    }

    public static SyntaxObjectIdentifier getSyntaxObjectIdentifier(String oid) {
        SyntaxObjectIdentifier syntaxObjectIdentifier = SYNTAX_OBJECT_IDENTIFIERS.get(oid);
        if (syntaxObjectIdentifier == null) {
            throw new NoSuchElementException("There is no Syntax Object Identifier for OID " + oid);
        }
        return syntaxObjectIdentifier;
    }

    public static boolean isHumanReadable(String oid) {
        return SyntaxObjectIdentifier.getSyntaxObjectIdentifier(oid).isHumanReadable();
    }

    static {
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("ACI Item", false, "1.3.6.1.4.1.1466.115.121.1.1"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Access Point", true, "1.3.6.1.4.1.1466.115.121.1.2"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Attribute Type Description", true, "1.3.6.1.4.1.1466.115.121.1.3"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Audio", false, "1.3.6.1.4.1.1466.115.121.1.4"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Binary", false, "1.3.6.1.4.1.1466.115.121.1.5"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Bit String", true, "1.3.6.1.4.1.1466.115.121.1.6"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Boolean", true, "1.3.6.1.4.1.1466.115.121.1.7"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Certificate", false, "1.3.6.1.4.1.1466.115.121.1.8"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Certificate List", false, "1.3.6.1.4.1.1466.115.121.1.9"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Certificate Pair", false, "1.3.6.1.4.1.1466.115.121.1.10"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Country String", true, "1.3.6.1.4.1.1466.115.121.1.11"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("DN", true, "1.3.6.1.4.1.1466.115.121.1.12"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Data Quality Syntax", true, "1.3.6.1.4.1.1466.115.121.1.13"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Delivery Method", true, "1.3.6.1.4.1.1466.115.121.1.14"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Directory String", true, "1.3.6.1.4.1.1466.115.121.1.15"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("DIT Content Rule Description", true, "1.3.6.1.4.1.1466.115.121.1.16"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("DIT Structure Rule Description", true, "1.3.6.1.4.1.1466.115.121.1.17"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("DL Submit Permission", true, "1.3.6.1.4.1.1466.115.121.1.18"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("DSA Quality Syntax", true, "1.3.6.1.4.1.1466.115.121.1.19"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("DSE Type", true, "1.3.6.1.4.1.1466.115.121.1.20"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Enhanced Guide", true, "1.3.6.1.4.1.1466.115.121.1.21"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Facsimile Telephone Number", true, "1.3.6.1.4.1.1466.115.121.1.22"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Fax", false, "1.3.6.1.4.1.1466.115.121.1.23"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Generalized Time", true, "1.3.6.1.4.1.1466.115.121.1.24"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Guide", true, "1.3.6.1.4.1.1466.115.121.1.25"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("IA5 String", true, "1.3.6.1.4.1.1466.115.121.1.26"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("INTEGER", true, "1.3.6.1.4.1.1466.115.121.1.27"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("JPEG", false, "1.3.6.1.4.1.1466.115.121.1.28"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("LDAP Syntax Description", true, "1.3.6.1.4.1.1466.115.121.1.54"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("LDAP Schema Definition", true, "1.3.6.1.4.1.1466.115.121.1.56"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("LDAP Schema Description", true, "1.3.6.1.4.1.1466.115.121.1.57"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Master And Shadow Access Points", true, "1.3.6.1.4.1.1466.115.121.1.29"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Matching Rule Description", true, "1.3.6.1.4.1.1466.115.121.1.30"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Matching Rule Use Description", true, "1.3.6.1.4.1.1466.115.121.1.31"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Mail Preference", true, "1.3.6.1.4.1.1466.115.121.1.32"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("MHS OR Address", true, "1.3.6.1.4.1.1466.115.121.1.33"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Modify Rights", true, "1.3.6.1.4.1.1466.115.121.1.55"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Name And Optional UID", true, "1.3.6.1.4.1.1466.115.121.1.34"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Name Form Description", true, "1.3.6.1.4.1.1466.115.121.1.35"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Numeric String", true, "1.3.6.1.4.1.1466.115.121.1.36"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Object Class Description", true, "1.3.6.1.4.1.1466.115.121.1.37"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Octet String", true, "1.3.6.1.4.1.1466.115.121.1.40"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("OID", true, "1.3.6.1.4.1.1466.115.121.1.38"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Other Mailbox", true, "1.3.6.1.4.1.1466.115.121.1.39"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Postal Address", true, "1.3.6.1.4.1.1466.115.121.1.41"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Protocol Information", true, "1.3.6.1.4.1.1466.115.121.1.42"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Presentation Address", true, "1.3.6.1.4.1.1466.115.121.1.43"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Printable String", true, "1.3.6.1.4.1.1466.115.121.1.44"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Substring Assertion", true, "1.3.6.1.4.1.1466.115.121.1.58"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Subtree Specification", true, "1.3.6.1.4.1.1466.115.121.1.45"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Supplier Information", true, "1.3.6.1.4.1.1466.115.121.1.46"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Supplier Or Consumer", true, "1.3.6.1.4.1.1466.115.121.1.47"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Supplier And Consumer", true, "1.3.6.1.4.1.1466.115.121.1.48"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Supported Algorithm", false, "1.3.6.1.4.1.1466.115.121.1.49"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Telephone Number", true, "1.3.6.1.4.1.1466.115.121.1.50"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Teletex Terminal Identifier", true, "1.3.6.1.4.1.1466.115.121.1.51"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("Telex Number", true, "1.3.6.1.4.1.1466.115.121.1.52"));
        SyntaxObjectIdentifier.addSyntaxObjectIdentifier(new SyntaxObjectIdentifier("UTC Time", true, "1.3.6.1.4.1.1466.115.121.1.53"));
    }
}

