/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.model;

import java.io.Serializable;
import java.util.List;
import org.mule.extension.ldap.internal.model.LDAPEntryAttributeTypeDefinition;
import org.mule.extension.ldap.internal.util.LDAPUtils;

public abstract class LDAPEntryAttribute
implements Serializable {
    private static final long serialVersionUID = -1854622206842090871L;
    private String name = null;
    private LDAPEntryAttributeTypeDefinition typeDefinition = null;

    public LDAPEntryAttribute() {
    }

    public LDAPEntryAttribute(String name) {
        this.setName(name);
    }

    public abstract Object getValue();

    public abstract List<Object> getValues();

    public abstract boolean isMultiValued();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toLDIFString() {
        StringBuilder buffer = new StringBuilder();
        for (Object value : this.getValues()) {
            buffer.append(this.getName());
            if (value instanceof byte[]) {
                buffer.append(":: ");
                buffer.append(LDAPUtils.encodeBase64((byte[])value));
            } else {
                buffer.append(": ");
                buffer.append(String.valueOf(value));
            }
            buffer.append(LDAPUtils.NEW_LINE);
        }
        return buffer.toString();
    }

    public LDAPEntryAttributeTypeDefinition getTypeDefinition() {
        return this.typeDefinition;
    }

    public void setTypeDefinition(LDAPEntryAttributeTypeDefinition typeDefinition) {
        this.typeDefinition = typeDefinition;
    }
}

