/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.extension.ldap.internal.error.LDAPErrorType;
import org.mule.extension.ldap.internal.error.exception.LDAPException;
import org.mule.extension.ldap.internal.model.LDAPEntryAttribute;
import org.mule.extension.ldap.internal.model.LDAPEntryAttributes;
import org.mule.extension.ldap.internal.model.LDAPMultiValueEntryAttribute;
import org.mule.extension.ldap.internal.model.LDAPSingleValueEntryAttribute;
import org.mule.extension.ldap.internal.util.LDAPUtils;

public class LDAPEntry
implements Serializable,
Map<String, Object> {
    public static final String MAP_DN_KEY = "dn";
    private static final long serialVersionUID = 194192089581212405L;
    private String dn = null;
    private LDAPEntryAttributes attributes = new LDAPEntryAttributes();

    public LDAPEntry() {
        this((String)null);
    }

    public LDAPEntry(String dn) {
        this.setDn(dn);
    }

    public LDAPEntry(String dn, Map<String, ?> attributes) {
        if (dn == null) {
            throw new IllegalArgumentException("Entry DN cannot be null.");
        }
        HashMap entry = new HashMap(attributes);
        entry.put(MAP_DN_KEY, dn);
        try {
            this.fromMap(entry);
        }
        catch (LDAPException ex) {
            throw new IllegalArgumentException((Throwable)((Object)ex));
        }
    }

    public LDAPEntry(Map<String, Object> entry) {
        this.fromMap(new HashMap<String, Object>(entry));
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public void addAttribute(LDAPEntryAttribute attribute) {
        this.attributes.addAttribute(attribute);
    }

    public void addAttribute(String attributeName, Object attributeValue) {
        if (attributeValue instanceof Collection) {
            this.addAttribute(new LDAPMultiValueEntryAttribute(attributeName, (Collection)attributeValue));
        } else if (attributeValue instanceof Object[]) {
            this.addAttribute(new LDAPMultiValueEntryAttribute(attributeName, (Object[])attributeValue));
        } else {
            this.addAttribute(new LDAPSingleValueEntryAttribute(attributeName, attributeValue));
        }
    }

    public LDAPEntryAttribute getAttribute(String name) {
        if (name != null) {
            return this.getAttributes().getAttribute(name);
        }
        return null;
    }

    public void resetAttributes() {
        this.attributes.resetAttributes();
    }

    public int getAttributeCount() {
        return this.attributes.getCount();
    }

    public Iterator<LDAPEntryAttribute> attributes() {
        return this.attributes.attributes();
    }

    public String toLDIFString() {
        StringBuilder entryLdif = new StringBuilder();
        entryLdif.append("dn: " + this.getDn() + LDAPUtils.NEW_LINE);
        Iterator<LDAPEntryAttribute> it = this.attributes();
        while (it.hasNext()) {
            LDAPEntryAttribute anAttr = it.next();
            entryLdif.append(anAttr.toLDIFString());
        }
        entryLdif.append(LDAPUtils.NEW_LINE);
        return entryLdif.toString();
    }

    private void fromMap(Map<String, ?> entry) {
        Object entryDN = entry.remove(MAP_DN_KEY);
        if (entryDN == null || !(entryDN instanceof String)) {
            throw new LDAPException("The map representing the LDAP entry should contain the key 'dn' with the string value of the DN (Distinguished Name) of the entry.", LDAPErrorType.UNKNOWN);
        }
        this.setDn((String)entryDN);
        Iterator<String> iterator = entry.keySet().iterator();
        while (iterator.hasNext()) {
            String s;
            String attr = s = iterator.next();
            Object value = entry.get(attr);
            this.addAttribute(attr, value);
        }
    }

    public String toString() {
        return this.toLDIFString();
    }

    public LDAPEntryAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(LDAPEntryAttributes attributes) {
        this.attributes = attributes;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof LDAPEntry)) {
            return false;
        }
        LDAPEntry entry = (LDAPEntry)obj;
        return this.getDn() != null && this.getDn().equals(entry.getDn());
    }

    @Override
    public int hashCode() {
        return this.getDn() != null ? this.getDn().hashCode() : super.hashCode();
    }

    @Override
    public void clear() {
        this.getAttributes().resetAttributes();
        this.setDn(null);
    }

    private String getKeyAsString(Object key) {
        if (key == null || key instanceof String) {
            return (String)key;
        }
        throw new IllegalArgumentException("Key should be a string. " + key.getClass() + " is not supported");
    }

    @Override
    public boolean containsKey(Object key) {
        if (MAP_DN_KEY.equals(key)) {
            return this.getDn() != null;
        }
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashMap<String, Object> mappedAttributes = new HashMap<String, Object>();
        for (Map.Entry<String, LDAPEntryAttribute> entry : this.attributes.entrySet()) {
            mappedAttributes.put(entry.getKey(), entry.getValue());
        }
        if (this.getDn() != null) {
            mappedAttributes.put(MAP_DN_KEY, this.getDn());
        }
        return mappedAttributes.entrySet();
    }

    @Override
    public Object get(Object key) {
        String keyAsString = this.getKeyAsString(key);
        if (MAP_DN_KEY.equals(keyAsString)) {
            return this.getDn();
        }
        LDAPEntryAttribute attr = this.getAttribute(keyAsString);
        if (attr != null) {
            return attr.isMultiValued() ? attr.getValues() : attr.getValue();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.getDn() == null && this.getAttributeCount() <= 0;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>(this.attributes.getCount() + 1);
        if (this.getDn() != null) {
            keys.add(MAP_DN_KEY);
        }
        Iterator<LDAPEntryAttribute> it = this.attributes();
        while (it.hasNext()) {
            LDAPEntryAttribute anAttr = it.next();
            keys.add(anAttr.getName());
        }
        return keys;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object put(String key, Object value) {
        if (MAP_DN_KEY.equals(key)) {
            if (value != null && !(value instanceof String)) throw new IllegalArgumentException("DN should be a string. " + key.getClass() + " is not supported");
            this.setDn((String)value);
            return value;
        } else {
            this.addAttribute(key, value);
        }
        return value;
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Object remove(Object key) {
        if (MAP_DN_KEY.equals(key)) {
            String dnToBeRemoved = this.getDn();
            this.setDn(null);
            return dnToBeRemoved;
        }
        return this.attributes.removeAttribute(this.getKeyAsString(key));
    }

    @Override
    public int size() {
        return this.getDn() != null ? 1 : this.getAttributeCount();
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> values = new ArrayList<Object>(this.attributes.getCount() + 1);
        if (this.getDn() != null) {
            values.add(this.getDn());
        }
        Iterator<LDAPEntryAttribute> it = this.attributes();
        while (it.hasNext()) {
            LDAPEntryAttribute anAttr = it.next();
            if (!anAttr.isMultiValued()) {
                values.add(anAttr.getValue());
                continue;
            }
            values.add(anAttr.getValues());
        }
        return values;
    }

    public static LDAPEntry getInstanceFromMap(Map<String, Object> entryMap) {
        return entryMap instanceof LDAPEntry ? (LDAPEntry)entryMap : new LDAPEntry(entryMap);
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> entryMap = new HashMap<String, Object>();
        if (this.getDn() != null) {
            entryMap.put(MAP_DN_KEY, this.getDn());
        }
        LDAPEntryAttribute ldapEntryAttribute = null;
        Iterator<LDAPEntryAttribute> iterator = this.attributes();
        while (iterator.hasNext()) {
            ldapEntryAttribute = iterator.next();
            if (!ldapEntryAttribute.isMultiValued()) {
                entryMap.put(ldapEntryAttribute.getName(), ldapEntryAttribute.getValue());
                continue;
            }
            entryMap.put(ldapEntryAttribute.getName(), ldapEntryAttribute.getValues());
        }
        return entryMap;
    }

    public static List<Map<String, Object>> getListOfMaps(List<LDAPEntry> ldapEntries) {
        ArrayList<Map<String, Object>> resultMaps = new ArrayList<Map<String, Object>>();
        if (ldapEntries != null) {
            for (LDAPEntry ldapEntry : ldapEntries) {
                resultMaps.add(ldapEntry.toMap());
            }
        }
        return resultMaps;
    }
}

