/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractLDAPEntryDefinition
implements Serializable {
    private static final long serialVersionUID = -7441401978161427169L;
    public static final String NUMERICOID = "NUMERICOID";
    public static final String NAME = "NAME";
    public static final String DESC = "DESC";
    public static final String OBSOLETE = "OBSOLETE";
    public static final String SUP = "SUP";
    protected Map<String, Object> attributes = new HashMap<String, Object>();

    protected String getAttributeAsString(String attrName) {
        Object attr = this.attributes.get(attrName);
        if (attr != null) {
            return attr instanceof String ? (String)attr : String.valueOf(attr);
        }
        return null;
    }

    protected boolean getAttributeAsBoolean(String attrName) {
        String attr = this.getAttributeAsString(attrName);
        return attr != null && "true".equalsIgnoreCase(attr);
    }

    public void set(String attributeName, Object attributeValue) {
        this.attributes.put(attributeName.toUpperCase(), attributeValue);
    }

    public Object get(String attributeName) {
        return this.attributes.get(attributeName.toUpperCase());
    }

    public String getNumericOid() {
        return this.getAttributeAsString(NUMERICOID);
    }

    public void setNumericOid(String numericOid) {
        this.attributes.put(NUMERICOID, numericOid);
    }

    public String getName() {
        return this.getAttributeAsString(NAME);
    }

    public void setName(String name) {
        this.attributes.put(NAME, name);
    }

    public String getDescription() {
        return this.getAttributeAsString(DESC);
    }

    public void setDescription(String description) {
        this.attributes.put(DESC, description);
    }

    public boolean isObsolete() {
        return this.getAttributeAsBoolean(OBSOLETE);
    }

    public void setObsolete(boolean obsolete) {
        this.attributes.put(OBSOLETE, String.valueOf(obsolete));
    }

    public String getSupName() {
        return this.getAttributeAsString(SUP);
    }

    public void setSupName(String supName) {
        this.attributes.put(SUP, supName);
    }

    public int hashCode() {
        return this.getNumericOid().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (obj instanceof AbstractLDAPEntryDefinition) {
            return this.getNumericOid().equals(((AbstractLDAPEntryDefinition)obj).getNumericOid());
        }
        return false;
    }

    public String toString() {
        return this.getName() != null ? this.getName() : this.getNumericOid();
    }
}

