/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.mule.extension.ldap.internal.connection.LDAPConnection;
import org.mule.extension.ldap.internal.model.LDAPEntryAttributeTypeDefinition;
import org.mule.extension.ldap.internal.model.datasense.LDAPEntryObjectClassDefinition;
import org.mule.extension.ldap.internal.model.datasense.SyntaxObjectIdentifier;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;

public class MetaDataBuilder {
    private static final String TOP_OBJECT_CLASS = "top";
    private LDAPConnection connection;

    public MetaDataBuilder(LDAPConnection connection) {
        this.connection = connection;
    }

    public List<String> getObjectClassHierarchyFor(String objectClass) {
        ArrayList<String> objectClasses = new ArrayList<String>();
        LDAPEntryObjectClassDefinition objectClassDefinition = this.getConnection().getObjectClassDefinition(objectClass);
        objectClasses.add(objectClassDefinition.getName());
        this.transverseObjectClassHierarchy(objectClassDefinition.getSupName(), objectClasses);
        return objectClasses;
    }

    public void transverseObjectClassHierarchy(@NotNull String supObjectClass, @NotNull List<String> objectClasses) {
        objectClasses.add(supObjectClass);
        if (!TOP_OBJECT_CLASS.equalsIgnoreCase(supObjectClass)) {
            LDAPEntryObjectClassDefinition objectClassDefinition = this.getConnection().getObjectClassDefinition(supObjectClass);
            this.transverseObjectClassHierarchy(objectClassDefinition.getSupName(), objectClasses);
        }
    }

    public void transverseObjectClassHierarchy(@NotNull LDAPEntryObjectClassDefinition objectClass, ObjectTypeBuilder typeBuilder, boolean showAttributesAsObjects) {
        this.addAttributesMetaData(objectClass.getMust(), typeBuilder, showAttributesAsObjects);
        this.addAttributesMetaData(objectClass.getMay(), typeBuilder, showAttributesAsObjects);
        if (objectClass.getSupName() != null && !TOP_OBJECT_CLASS.equalsIgnoreCase(objectClass.getSupName())) {
            LDAPEntryObjectClassDefinition parentObjectClass = this.getConnection().getObjectClassDefinition(objectClass.getSupName());
            this.transverseObjectClassHierarchy(parentObjectClass, typeBuilder, showAttributesAsObjects);
        }
    }

    public void addAttributesMetaData(List<String> attributes, ObjectTypeBuilder typeBuilder, boolean showAttributesAsObjects) {
        if (attributes == null) {
            return;
        }
        for (String attribute : attributes) {
            if (showAttributesAsObjects) {
                typeBuilder.addField().key(attribute).value(this.createAttributeObjectMetadataType(attribute));
                continue;
            }
            LDAPEntryAttributeTypeDefinition attributeDefinition = this.getConnection().getAttributeTypeDefinition(attribute);
            if (attributeDefinition.isSingleValue()) {
                if (this.isStringDataType(attributeDefinition)) {
                    typeBuilder.addField().key(attribute).value().stringType();
                    continue;
                }
                typeBuilder.addField().key(attribute).value().anyType();
                continue;
            }
            typeBuilder.addField().key(attribute).value().anyType();
        }
    }

    public MetadataType createAttributeObjectMetadataType(String name) {
        ObjectTypeBuilder objectBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        objectBuilder.id(name);
        objectBuilder.addField().key("value").value().anyType();
        objectBuilder.addField().key("typeDefinition").value(this.createAttributeTypeDefinitionMetadatatype());
        objectBuilder.addField().key("name").value().stringType();
        objectBuilder.addField().key("multiValued").value().booleanType();
        objectBuilder.addField().key("values").value().arrayType().of().anyType();
        return objectBuilder.build();
    }

    public MetadataType createAttributeTypeDefinitionMetadatatype() {
        ObjectTypeBuilder objectBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
        objectBuilder.id("typedef");
        objectBuilder.addField().key("noUserModification").value().booleanType();
        objectBuilder.addField().key("ordering").value().anyType();
        objectBuilder.addField().key("usage").value().anyType();
        objectBuilder.addField().key("obsolete").value().booleanType();
        objectBuilder.addField().key("singleValue").value().booleanType();
        objectBuilder.addField().key("description").value().stringType();
        objectBuilder.addField().key("substring").value().anyType();
        objectBuilder.addField().key("numericOid").value().stringType();
        objectBuilder.addField().key("name").value().stringType();
        objectBuilder.addField().key("syntax").value().stringType();
        objectBuilder.addField().key("collective").value().booleanType();
        objectBuilder.addField().key("supName").value().anyType();
        objectBuilder.addField().key("equality").value().stringType();
        return objectBuilder.build();
    }

    private boolean isStringDataType(LDAPEntryAttributeTypeDefinition attribute) {
        try {
            return SyntaxObjectIdentifier.isHumanReadable(attribute.getSyntax());
        }
        catch (NoSuchElementException noSuchElementException) {
            return true;
        }
    }

    @NotNull
    public LDAPConnection getConnection() {
        return this.connection;
    }

    public void setConnection(@NotNull LDAPConnection connection) {
        this.connection = connection;
    }
}

