/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.metadata;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.mule.extension.ldap.internal.config.LDAPConfiguration;
import org.mule.extension.ldap.internal.connection.LDAPConnection;
import org.mule.extension.ldap.internal.metadata.MetaDataBuilder;
import org.mule.extension.ldap.internal.model.datasense.LDAPEntryObjectClassDefinition;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeyBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.core.api.util.StringUtils;

public class LDAPEntryObjectClassMetadataResolver
implements InputTypeResolver<String>,
OutputTypeResolver<String>,
TypeKeysResolver {
    public Set<MetadataKey> getKeys(MetadataContext context) throws MetadataResolvingException, ConnectionException {
        HashSet<MetadataKey> keys = new HashSet<MetadataKey>();
        try {
            Optional optional = context.getConnection();
            LDAPConnection ldapConnection = (LDAPConnection)optional.get();
            List<String> objectClasses = ldapConnection.getAllObjectClasses();
            for (String objectClass : objectClasses) {
                keys.add(MetadataKeyBuilder.newKey((String)objectClass).withDisplayName(objectClass).build());
            }
        }
        catch (Exception ex) {
            throw new MetadataResolvingException(ex.getMessage(), FailureCode.UNKNOWN, (Throwable)ex);
        }
        return keys;
    }

    public MetadataType getOutputType(MetadataContext context, String key) throws MetadataResolvingException, ConnectionException {
        try {
            Optional optional = context.getConnection();
            LDAPConnection ldapConnection = (LDAPConnection)optional.get();
            LDAPConfiguration config = (LDAPConfiguration)context.getConfig().get();
            BaseTypeBuilder baseBuilder = new BaseTypeBuilder(JavaTypeLoader.JAVA);
            if (StringUtils.isBlank((String)key)) {
                return baseBuilder.objectType().build();
            }
            LDAPEntryObjectClassDefinition objectClass = ldapConnection.getObjectClassDefinition(key);
            ObjectTypeBuilder typeBuilder = baseBuilder.objectType().id(key).label(key);
            MetaDataBuilder metadataBuilder = ldapConnection.getMetaDataBuilder();
            metadataBuilder.transverseObjectClassHierarchy(objectClass, typeBuilder, config.isShowAttributesAsObjects());
            return typeBuilder.build();
        }
        catch (Exception ex) {
            throw new MetadataResolvingException(ex.getMessage(), FailureCode.UNKNOWN, (Throwable)ex);
        }
    }

    public MetadataType getInputMetadata(MetadataContext context, String key) throws MetadataResolvingException, ConnectionException {
        return this.getOutputType(context, key);
    }

    public String getCategoryName() {
        return this.getClass().getSimpleName();
    }

    public String getResolverName() {
        return this.getClass().getSimpleName();
    }
}

