/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.connection.provider;

import org.mule.connectors.commons.template.connection.ConnectorConnectionProvider;
import org.mule.extension.ldap.api.parameters.BasicAuthAdvancedPoolingParameterGroup;
import org.mule.extension.ldap.api.parameters.BasicAuthParameterGroup;
import org.mule.extension.ldap.internal.connection.LDAPConnection;
import org.mule.extension.ldap.internal.error.exception.LDAPException;
import org.mule.extension.ldap.internal.parameters.bundle.BasicParamsBundle;
import org.mule.extension.ldap.internal.service.connection.ConnectionService;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Alias(value="basic")
@DisplayName(value="Basic Configuration")
public class BasicConnectionProvider
extends ConnectorConnectionProvider<LDAPConnection>
implements ConnectionProvider<LDAPConnection> {
    private static final Logger logger = LoggerFactory.getLogger(BasicConnectionProvider.class);
    private static final String BASIC = "basic";
    @ParameterGroup(name="Connection")
    @Placement(order=1)
    private BasicAuthParameterGroup basicAuthParams;
    @ParameterGroup(name="Advanced")
    @Placement(order=2)
    private BasicAuthAdvancedPoolingParameterGroup basicAuthAdvancedPoolingParams;
    private ConnectionService connectionService = new ConnectionService("basic");

    public LDAPConnection connect() throws ConnectionException {
        BasicParamsBundle basicParamsBundle = new BasicParamsBundle();
        basicParamsBundle.setBasicAuthParams(this.basicAuthParams);
        basicParamsBundle.setBasicAuthAdvancedPoolingParams(this.basicAuthAdvancedPoolingParams);
        return this.connectionService.connect(basicParamsBundle);
    }

    public void disconnect(LDAPConnection ldapConnection) {
        try {
            ldapConnection.disconnect();
        }
        catch (LDAPException e) {
            logger.debug("Error while executing disconnect method : {}, {} ", (Object)e.getMessage(), (Object)e);
        }
    }

    public ConnectionValidationResult validate(LDAPConnection ldapConnection) {
        try {
            ldapConnection.validate();
            return ConnectionValidationResult.success();
        }
        catch (Exception e) {
            return ConnectionValidationResult.failure((String)e.getMessage(), (Exception)e);
        }
    }

    public void setBasicAuthParams(BasicAuthParameterGroup basicAuthParams) {
        this.basicAuthParams = basicAuthParams;
    }

    public void setBasicAuthAdvancedPoolingParams(BasicAuthAdvancedPoolingParameterGroup basicAuthAdvancedPoolingParams) {
        this.basicAuthAdvancedPoolingParams = basicAuthAdvancedPoolingParams;
    }
}

