/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.ldap.internal.connection;

import java.util.Map;

public class ConnectionParameters {
    private String type;
    private String url;
    private String authentication;
    private int initialPoolSize;
    private int maxPoolSize;
    private long poolTimeout;
    private String referral;
    private Map<String, String> extendedConf;
    private boolean schemaEnabled;
    private boolean isTlsEnabled;
    private boolean isSslEnabled;

    public String getType() {
        return this.type;
    }

    public boolean isTlsEnabled() {
        return this.isTlsEnabled;
    }

    public boolean isSchemaEnabled() {
        return this.schemaEnabled;
    }

    public Map<String, String> getExtendedConf() {
        return this.extendedConf;
    }

    public String getReferral() {
        return this.referral;
    }

    public long getPoolTimeout() {
        return this.poolTimeout;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    public String getAuthentication() {
        return this.authentication;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isSslEnabled() {
        return this.isSslEnabled;
    }

    private ConnectionParameters(ConnectionParametersBuilder builder) {
        this.type = builder.type;
        this.url = builder.url;
        this.authentication = builder.authentication;
        this.initialPoolSize = builder.initialPoolSize;
        this.maxPoolSize = builder.maxPoolSize;
        this.poolTimeout = builder.poolTimeout;
        this.referral = builder.referral;
        this.extendedConf = builder.extendedConf;
        this.schemaEnabled = builder.schemaEnabled;
        this.isTlsEnabled = builder.tlsEnabled;
        this.isSslEnabled = builder.sslEnabled;
    }

    public static class ConnectionParametersBuilder {
        private boolean sslEnabled;
        private String type;
        private String url;
        private String authentication;
        private int initialPoolSize;
        private int maxPoolSize;
        private long poolTimeout;
        private String referral;
        private Map<String, String> extendedConf;
        private boolean schemaEnabled;
        private boolean tlsEnabled;

        public ConnectionParametersBuilder(String type, String url, String authentication) {
            this.type = type;
            this.url = url;
            this.authentication = authentication;
        }

        public ConnectionParametersBuilder setInitialPoolSize(int initialPoolSize) {
            this.initialPoolSize = initialPoolSize;
            return this;
        }

        public ConnectionParametersBuilder setMaxPoolSize(int maxPoolSize) {
            this.maxPoolSize = maxPoolSize;
            return this;
        }

        public ConnectionParametersBuilder setPoolTimeout(long poolTimeout) {
            this.poolTimeout = poolTimeout;
            return this;
        }

        public ConnectionParametersBuilder setReferral(String referral) {
            this.referral = referral;
            return this;
        }

        public ConnectionParametersBuilder setExtendedConf(Map<String, String> extendedConf) {
            this.extendedConf = extendedConf;
            return this;
        }

        public ConnectionParametersBuilder setSchemaEnabled(boolean schemaEnabled) {
            this.schemaEnabled = schemaEnabled;
            return this;
        }

        public ConnectionParametersBuilder setTlsEnabled(boolean tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
            return this;
        }

        public ConnectionParametersBuilder setSslEnabled(boolean sslEnabled) {
            this.sslEnabled = sslEnabled;
            return this;
        }

        public ConnectionParameters build() {
            return new ConnectionParameters(this);
        }
    }
}

