/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.commons.template.operation;

import com.mulesoft.connectors.commons.template.config.ConnectorConfig;
import com.mulesoft.connectors.commons.template.connection.ConnectorConnection;
import com.mulesoft.connectors.commons.template.operation.factory.ExecutionBuilderFactory;
import com.mulesoft.connectors.commons.template.service.ConnectorService;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.mule.commons.atlantic.Atlantic;
import org.mule.commons.atlantic.execution.builder.FunctionExecutionBuilder;
import org.mule.commons.atlantic.lambda.function.BiFunction;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;

public class ConnectorOperation<CONFIG extends ConnectorConfig, CONNECTION extends ConnectorConnection, SERVICE extends ConnectorService, EXECUTION_BUILDER_FACTORY extends ExecutionBuilderFactory<CONFIG, CONNECTION, SERVICE>> {
    private final EXECUTION_BUILDER_FACTORY executionBuilderFactory;

    protected ConnectorOperation(BiFunction<BiFunction<CONFIG, CONNECTION, SERVICE>, ErrorTypeDefinition<?>, EXECUTION_BUILDER_FACTORY> executionBuilderConstructor, BiFunction<CONFIG, CONNECTION, SERVICE> serviceConstructor, ErrorTypeDefinition<?> unexpectedErrorValue) {
        this.executionBuilderFactory = (ExecutionBuilderFactory)((FunctionExecutionBuilder)Atlantic.newStaticExecutionBuilder().execute(executionBuilderConstructor).withParam(serviceConstructor)).withParam(unexpectedErrorValue);
    }

    protected ConnectorOperation(BiFunction<BiFunction<CONFIG, CONNECTION, SERVICE>, ErrorTypeDefinition<?>, EXECUTION_BUILDER_FACTORY> executionBuilderConstructor, Class<SERVICE> serviceClass, Function<Class<SERVICE>, Class<? extends SERVICE>> transformer, ErrorTypeDefinition<?> unexpectedErrorValue) {
        this(executionBuilderConstructor, (config, connection) -> (ConnectorService)Stream.of(Optional.of(serviceClass).filter(Class::isInterface).map(transformer).orElse(serviceClass).getDeclaredConstructors()).filter(constructor -> ConnectorConfig.class.isAssignableFrom(constructor.getParameterTypes()[0]) && ConnectorConnection.class.isAssignableFrom(constructor.getParameterTypes()[1])).findFirst().orElseThrow(NoSuchMethodException::new).newInstance(config, connection), unexpectedErrorValue);
    }

    protected ConnectorOperation(BiFunction<BiFunction<CONFIG, CONNECTION, SERVICE>, ErrorTypeDefinition<?>, EXECUTION_BUILDER_FACTORY> executionBuilderConstructor, Class<SERVICE> serviceClass, ErrorTypeDefinition<?> unexpectedErrorValue) {
        this(executionBuilderConstructor, serviceClass, clazz -> {
            try {
                return Class.forName(String.format("%sImpl", serviceClass.getName()));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }, unexpectedErrorValue);
    }

    protected EXECUTION_BUILDER_FACTORY getExecutionBuilderFactory() {
        return this.executionBuilderFactory;
    }
}

