/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.commons.template.metadata;

import com.mulesoft.connectors.commons.template.config.ConnectorConfig;
import com.mulesoft.connectors.commons.template.connection.ConnectorConnection;
import com.mulesoft.connectors.commons.template.service.DefaultConnectorService;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.mule.commons.atlantic.Atlantic;
import org.mule.commons.atlantic.exception.UnhandledException;
import org.mule.commons.atlantic.execution.builder.FunctionExecutionBuilder;
import org.mule.commons.atlantic.execution.builder.factory.InstanceExecutionBuilderFactory;
import org.mule.commons.atlantic.lambda.function.BiFunction;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class ConnectorMetadataResolver<CONFIG extends ConnectorConfig, CONNECTION extends ConnectorConnection, SERVICE extends DefaultConnectorService, ERROR extends Enum<ERROR>> {
    private final BiFunction<CONFIG, CONNECTION, SERVICE> serviceConstructor;
    private final ERROR unknownErrorTypeDefinition;

    protected ConnectorMetadataResolver(BiFunction<CONFIG, CONNECTION, SERVICE> serviceConstructor, ERROR unknownErrorTypeDefinition) {
        this.serviceConstructor = serviceConstructor;
        this.unknownErrorTypeDefinition = unknownErrorTypeDefinition;
    }

    protected ConnectorMetadataResolver(Class<SERVICE> serviceClass, ERROR unknownErrorTypeDefinition) {
        this(serviceClass, clazz -> {
            try {
                return Class.forName(String.format("%sImpl", serviceClass.getName()));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }, unknownErrorTypeDefinition);
    }

    protected ConnectorMetadataResolver(Class<SERVICE> serviceClass, Function<Class<SERVICE>, Class<? extends SERVICE>> transformer, ERROR unknownErrorTypeDefinition) {
        this((config, connection) -> (DefaultConnectorService)Stream.of(Optional.of(serviceClass).filter(Class::isInterface).map(transformer).orElse(serviceClass).getDeclaredConstructors()).filter(constructor -> ConnectorConfig.class.isAssignableFrom(constructor.getParameterTypes()[0]) && ConnectorConnection.class.isAssignableFrom(constructor.getParameterTypes()[1])).findFirst().orElseThrow(NoSuchMethodException::new).newInstance(config, connection), unknownErrorTypeDefinition);
    }

    protected <RESULT> InstanceExecutionBuilderFactory<SERVICE, RESULT> newExecutionBuilderFactory(MetadataContext metadataContext) {
        try {
            return (InstanceExecutionBuilderFactory)((InstanceExecutionBuilderFactory)Atlantic.newInstanceExecutionBuilder((Object)((FunctionExecutionBuilder)Atlantic.newStaticExecutionBuilder().execute(this.serviceConstructor).withParam(metadataContext.getConfig().get())).withParam(metadataContext.getConnection().get())).withIgnoredExceptionType(ModuleException.class)).withExceptionHandler(Throwable.class, t -> new ModuleException((ErrorTypeDefinition)this.unknownErrorTypeDefinition, t));
        }
        catch (ConnectionException e) {
            throw new UnhandledException((Throwable)e);
        }
    }
}

