/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.commons.template.operation;

import com.mulesoft.connectors.commons.template.config.ConnectorConfig;
import com.mulesoft.connectors.commons.template.connection.ConnectorConnection;
import com.mulesoft.connectors.commons.template.service.ConnectorService;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.mule.commons.atlantic.Atlantic;
import org.mule.commons.atlantic.execution.builder.FunctionExecutionBuilder;
import org.mule.commons.atlantic.execution.builder.factory.InstanceExecutionBuilderFactory;
import org.mule.commons.atlantic.lambda.function.BiFunction;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;

public class ConnectorOperation<CONFIG extends ConnectorConfig, CONNECTION extends ConnectorConnection, SERVICE extends ConnectorService, ERROR extends Enum> {
    private final BiFunction<CONFIG, CONNECTION, SERVICE> serviceConstructorCall;
    private final ERROR unexpectedErrorValue;

    protected ConnectorOperation(BiFunction<CONFIG, CONNECTION, SERVICE> serviceConstructorCall, ERROR unexpectedErrorValue) {
        this.serviceConstructorCall = serviceConstructorCall;
        this.unexpectedErrorValue = unexpectedErrorValue;
    }

    protected ConnectorOperation(Class<SERVICE> serviceClass, Function<Class<SERVICE>, Class<? extends SERVICE>> transformer, ERROR unexpectedErrorValue) {
        this((config, connection) -> (ConnectorService)Stream.of(Optional.of(serviceClass).filter(Class::isInterface).map(transformer).orElse(serviceClass).getDeclaredConstructors()).filter(constructor -> ConnectorConfig.class.isAssignableFrom(constructor.getParameterTypes()[0]) && ConnectorConnection.class.isAssignableFrom(constructor.getParameterTypes()[1])).findFirst().orElseThrow(NoSuchMethodException::new).newInstance(config, connection), unexpectedErrorValue);
    }

    protected ConnectorOperation(Class<SERVICE> serviceClass, ERROR unexpectedErrorValue) {
        this(serviceClass, clazz -> {
            try {
                return Class.forName(String.format("%sImpl", serviceClass.getName()));
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }, unexpectedErrorValue);
    }

    protected <RESULT> InstanceExecutionBuilderFactory<SERVICE, RESULT> newExecutionBuilderFactory(CONFIG config, CONNECTION connection) {
        return (InstanceExecutionBuilderFactory)((InstanceExecutionBuilderFactory)Atlantic.newInstanceExecutionBuilder((Object)((FunctionExecutionBuilder)Atlantic.newStaticExecutionBuilder().execute(this.serviceConstructorCall).withParam(config)).withParam(connection)).withIgnoredExceptionType(ModuleException.class)).withExceptionHandler(Throwable.class, t -> {
            throw new ModuleException((ErrorTypeDefinition)this.unexpectedErrorValue, t);
        });
    }
}

