/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.cloudhub.internal.valueprovider.connection.environment;

import com.mulesoft.connectors.cloudhub.internal.connection.CloudHubConnection;
import com.mulesoft.connectors.cloudhub.internal.connection.providers.AbstractConnectionProvider;
import com.mulesoft.connectors.cloudhub.internal.operation.CloudHubOperations;
import com.mulesoft.connectors.cloudhub.internal.valueprovider.BaseValueProvider;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;

public abstract class BaseEnvironmentsValueProvider
extends BaseValueProvider {
    private static final String EXPRESSION = "%dw 2.0\noutput application/java\n---\n(payload.environments map ((key, val) -> {\n    \"$(key.id)\" : key.name\n})) reduce ($$ ++ $)";
    @Parameter
    protected String anypointPlatformUrl;

    public Set<Value> resolve() throws ValueResolvingException {
        CloudHubConnection connection = this.getConnection();
        ConnectionValidationResult validate = this.getConnectionProvider().validate(connection);
        if (!validate.isValid()) {
            throw new ValueResolvingException("Connectivity Issues trying to obtain a connection." + validate.getMessage(), "CONNECTIVITY", (Throwable)validate.getException());
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Reference refValues = new Reference();
        Reference throwableReference = new Reference();
        new CloudHubOperations().getAccount(connection, this.createCallbackHandler(countDownLatch, (Reference<Set<Value>>)refValues, (Reference<Throwable>)throwableReference, EXPRESSION));
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            throw new ValueResolvingException("Unexpected Error", "UNKNOWN", (Throwable)e);
        }
        if (throwableReference.get() != null) {
            throw new ValueResolvingException("Unexpected Error", "UNKNOWN", (Throwable)throwableReference.get());
        }
        Set values = (Set)refValues.get();
        connection.invalidate();
        return values;
    }

    public abstract CloudHubConnection getConnection();

    public abstract AbstractConnectionProvider getConnectionProvider();

    protected HttpClient createHttpClient() {
        HttpClientConfiguration.Builder builder = new HttpClientConfiguration.Builder();
        builder.setName("cloudhub-connector-environment");
        HttpClient httpClient = this.httpService.getClientFactory().create(builder.build());
        httpClient.start();
        return httpClient;
    }
}

