/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.cloudhub.internal.operation.utils;

import com.mulesoft.connectors.cloudhub.api.NotificationStatus;
import com.mulesoft.connectors.cloudhub.internal.error.CloudHubError;
import com.mulesoft.connectors.cloudhub.internal.error.CloudHubException;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.BiConsumer;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;

public class OperationUtils {
    private OperationUtils() {
    }

    public static BiConsumer<HttpResponse, Throwable> createCompletionHandler(CompletionCallback<InputStream, Void> completionCallback) {
        return OperationUtils.createCompletionHandler(completionCallback, null, null);
    }

    public static BiConsumer<HttpResponse, Throwable> createCompletionHandler(CompletionCallback completionCallback, String payloadExpression, ExpressionManager expressionManager) {
        return (httpResponse, e) -> {
            if (e != null || httpResponse.getStatusCode() / 100 != 2) {
                OperationUtils.validateHttpResponse(completionCallback, httpResponse, e);
            } else if (payloadExpression == null) {
                completionCallback.success(Result.builder().output((Object)httpResponse.getEntity().getContent()).mediaType(MediaType.APPLICATION_JSON).build());
            } else {
                InputStream content = httpResponse.getEntity().getContent();
                completionCallback.success(Result.builder().output(expressionManager.evaluate(payloadExpression, OperationUtils.createBinding(content)).getValue()).mediaType(MediaType.APPLICATION_JSON).build());
            }
        };
    }

    private static void validateHttpResponse(CompletionCallback<?, ?> completionCallback, HttpResponse response, Throwable throwable) {
        if (throwable != null) {
            completionCallback.error((Throwable)new RuntimeException("Unexpected Error Occurred", throwable));
        } else {
            String responseMessage;
            try {
                responseMessage = new String(response.getEntity().getBytes());
            }
            catch (IOException e) {
                completionCallback.error((Throwable)new RuntimeException("Unexpected Error Occurred", e));
                return;
            }
            switch (response.getStatusCode()) {
                case 401: {
                    completionCallback.error((Throwable)((Object)new CloudHubException("Invalid Credentials. Original Message: " + responseMessage, response.getStatusCode(), CloudHubError.INVALID_CREDENTIALS, new ConnectionException("Invalid Credentials"))));
                    break;
                }
                case 403: {
                    completionCallback.error((Throwable)((Object)new CloudHubException("Invalid Permissions. Original Message: " + responseMessage, response.getStatusCode(), CloudHubError.INVALID_PERMISSIONS, new ConnectionException("Invalid Permissions"))));
                    break;
                }
                default: {
                    completionCallback.error((Throwable)((Object)new CloudHubException("Unknown Error. Original Message: " + responseMessage, response.getStatusCode(), CloudHubError.EXECUTION)));
                }
            }
        }
    }

    private static BindingContext createBinding(InputStream content) {
        return BindingContext.builder().addBinding("payload", new TypedValue((Object)content, DataType.JSON_STRING)).build();
    }

    public static String toQueryParams(NotificationStatus status) {
        if (status.equals((Object)NotificationStatus.ALL)) {
            return null;
        }
        return status.toString();
    }
}

