/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.cloudhub.internal.connection.utils;

import java.util.HashMap;
import org.mule.oauth.client.api.ClientCredentialsOAuthDancer;
import org.mule.oauth.client.api.builder.ClientCredentialsLocation;
import org.mule.oauth.client.api.builder.OAuthDancerBuilder;
import org.mule.oauth.client.api.http.HttpClientFactory;
import org.mule.oauth.client.internal.builder.DefaultOAuthAuthorizationCodeDancerBuilder;
import org.mule.oauth.client.internal.builder.DefaultOAuthClientCredentialsDancerBuilder;
import org.mule.oauth.client.internal.config.AuthDancerCredentialConfig;
import org.mule.oauth.client.internal.config.DefaultAuthorizationCodeOAuthDancerConfig;
import org.mule.oauth.client.internal.config.DefaultClientCredentialsOAuthDancerConfig;
import org.mule.oauth.client.internal.config.OAuthDancerConfig;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;

public class OAuthUtils {
    public static final int MAX_REFRESH_ATTEMPTS = 2;

    public static DefaultClientCredentialsOAuthDancerConfig createClientCredentialsConfig(String clientId, String clientSecret, String anypointPlatformUrl) {
        DefaultClientCredentialsOAuthDancerConfig clientCredentialsCfg = new DefaultClientCredentialsOAuthDancerConfig();
        clientCredentialsCfg.setCredentialConfig(AuthDancerCredentialConfig.builder().withClientId(clientId).withClientSecret(clientSecret).withClientCredentialsLocation(ClientCredentialsLocation.BODY).build());
        clientCredentialsCfg.setTokenUrl(anypointPlatformUrl + "/accounts/api/v2/oauth2/token");
        clientCredentialsCfg.setTokensStore(new HashMap());
        return clientCredentialsCfg;
    }

    public static OAuthDancerConfig setOAuthContext(OAuthDancerConfig config, HttpClient httpClient, SchedulerService schedulerService, LockFactory lockProvider, MuleExpressionLanguage expressionEvaluator) {
        config.setExpressionEvaluator(expressionEvaluator);
        config.setLockProvider(lockProvider);
        config.setSchedulerService(schedulerService);
        config.setHttpClient(httpClient);
        return config;
    }

    public static <T extends ClientCredentialsOAuthDancer, AuthorizationCodeOAuthDancer, S extends DefaultClientCredentialsOAuthDancerConfig, DefaultAuthorizationCodeOAuthDancerConfig> T createDancer(S config, HttpService httpService) {
        OAuthDancerBuilder builder = OAuthUtils.getDancerBuilder(config, httpService);
        builder.clientCredentials(config.getCredentialConfig().getClientId(), config.getCredentialConfig().getClientSecret()).withClientCredentialsIn(config.getCredentialConfig().getClientCredentialsLocation()).tokenUrl(config.getTokenUrl());
        ClientCredentialsOAuthDancer dancer = (ClientCredentialsOAuthDancer)builder.build();
        try {
            LifecycleUtils.initialiseIfNeeded((Object)dancer);
            LifecycleUtils.startIfNeeded((Object)dancer);
        }
        catch (MuleException e) {
            throw new RuntimeException(e);
        }
        return (T)dancer;
    }

    private static OAuthDancerBuilder getDancerBuilder(DefaultClientCredentialsOAuthDancerConfig config, HttpService httpService) {
        return new DefaultOAuthClientCredentialsDancerBuilder(config.getSchedulerService(), config.getLockProvider(), config.getTokensStore(), HttpClientFactory.getDefault((HttpService)httpService), config.getExpressionEvaluator());
    }

    private static OAuthDancerBuilder getDancerBuilder(DefaultAuthorizationCodeOAuthDancerConfig config, HttpService httpService) {
        return new DefaultOAuthAuthorizationCodeDancerBuilder(config.getSchedulerService(), config.getLockProvider(), config.getTokensStore(), httpService, HttpClientFactory.getDefault((HttpService)httpService), config.getExpressionEvaluator());
    }
}

