/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.cloudhub.internal.connection.providers;

import com.mulesoft.connectors.cloudhub.internal.connection.CloudHubConnection;
import com.mulesoft.connectors.cloudhub.internal.error.CloudHubConnectivityException;
import com.mulesoft.connectors.cloudhub.internal.error.CloudHubError;
import com.mulesoft.connectors.cloudhub.internal.error.CloudHubException;
import com.mulesoft.connectors.cloudhub.internal.error.CloudHubTokenException;
import com.mulesoft.connectors.cloudhub.internal.valueprovider.connection.AnypointPlatformUrlValueProvider;
import java.io.InputStream;
import javax.inject.Inject;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectionProvider
implements CachedConnectionProvider<CloudHubConnection>,
Startable,
Stoppable {
    protected final Logger LOGGER = LoggerFactory.getLogger(AbstractConnectionProvider.class);
    @Parameter
    @Optional(defaultValue="https://anypoint.mulesoft.com")
    @Placement(tab="Advanced")
    @OfValues(value=AnypointPlatformUrlValueProvider.class)
    @DisplayName(value="Anypoint Platform URL")
    protected String anypointPlatformUrl;
    @Inject
    protected HttpService httpService;
    protected HttpClient httpClient;

    public abstract CloudHubConnection connect();

    public void disconnect(CloudHubConnection connection) {
        connection.invalidate();
    }

    public ConnectionValidationResult validate(CloudHubConnection connection) {
        try {
            HttpResponse httpResponse = connection.permissions.getPermissions().get();
            int statusCode = httpResponse.getStatusCode();
            if (statusCode / 100 != 2) {
                String response = IOUtils.toString((InputStream)httpResponse.getEntity().getContent());
                switch (statusCode) {
                    case 401: {
                        return ConnectionValidationResult.failure((String)("Invalid Credentials. Original Message: " + response), (Exception)((Object)new CloudHubException("Invalid Credentials", statusCode, CloudHubError.INVALID_CREDENTIALS)));
                    }
                    case 403: {
                        return ConnectionValidationResult.failure((String)("Invalid Permissions. Original Message: " + response), (Exception)((Object)new CloudHubException("Invalid Permissions", statusCode, CloudHubError.INVALID_PERMISSIONS)));
                    }
                }
                return ConnectionValidationResult.failure((String)("Unknown Error occurred tyring to validate the connection. Original Message: " + response), (Exception)((Object)new CloudHubConnectivityException("Unknown Error occurred tyring to validate the connection")));
            }
        }
        catch (CloudHubTokenException e) {
            return ConnectionValidationResult.failure((String)("Invalid Credentials. Original Message: " + e.getMessage()), (Exception)((Object)new CloudHubException("Invalid Credentials", 401, CloudHubError.INVALID_CREDENTIALS)));
        }
        catch (Exception e) {
            return ConnectionValidationResult.failure((String)"Unexpected Error occurred trying to validate the connection.", (Exception)((Object)new CloudHubConnectivityException(e.getMessage(), e)));
        }
        return ConnectionValidationResult.success();
    }

    protected HttpClient createClient(HttpService httpService) {
        HttpClientConfiguration.Builder builder = new HttpClientConfiguration.Builder();
        builder.setName("cloudhub-connector");
        HttpClient httpClient = httpService.getClientFactory().create(builder.build());
        httpClient.start();
        return httpClient;
    }

    public void start() {
        this.httpClient = this.createClient(this.httpService);
    }

    public void stop() {
        if (this.httpClient != null) {
            this.httpClient.stop();
        }
    }
}

