/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.cloudhub.internal.connection;

import com.mulesoft.connectors.cloudhub.internal.operation.core.Account;
import com.mulesoft.connectors.cloudhub.internal.operation.core.Applications;
import com.mulesoft.connectors.cloudhub.internal.operation.core.Notifications;
import com.mulesoft.connectors.cloudhub.internal.operation.core.Permissions;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.runtime.http.api.domain.message.request.HttpRequestBuilder;
import org.mule.runtime.http.api.domain.message.response.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CloudHubConnection {
    protected static final Logger LOGGER = LoggerFactory.getLogger(CloudHubConnection.class);
    protected final HttpClient httpClient;
    private final String defaultEnvironment;
    private final String anypointPlatformUrl;
    public final Account account;
    public final Applications applications;
    public final Permissions permissions;
    public final Notifications notifications;

    public CloudHubConnection(HttpClient httpClient, String defaultEnvironment, String anypointPlatformUrl) {
        this.defaultEnvironment = defaultEnvironment;
        this.anypointPlatformUrl = anypointPlatformUrl;
        this.httpClient = httpClient;
        this.applications = new Applications(this);
        this.account = new Account(this);
        this.permissions = new Permissions(this);
        this.notifications = new Notifications(this);
    }

    public void invalidate() {
        if (this.httpClient != null) {
            this.httpClient.stop();
        }
    }

    protected HttpRequestBuilder buildRequest(Consumer<HttpRequestBuilder> httpRequestBuilderConsumer, String endpoint, HttpConstants.Method method) {
        HttpRequestBuilder builder = HttpRequest.builder();
        if (httpRequestBuilderConsumer != null) {
            httpRequestBuilderConsumer.accept(builder);
        }
        builder.method(method);
        builder.uri(this.anypointPlatformUrl + "/cloudhub/api" + endpoint);
        if (this.defaultEnvironment != null) {
            builder.addHeader("X-ANYPNT-ENV-ID", this.defaultEnvironment);
        }
        return builder;
    }

    public abstract CompletableFuture<HttpResponse> sendRequest(Consumer<HttpRequestBuilder> var1, String var2, HttpConstants.Method var3);
}

