/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.dynamodb.internal.util;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.Capacity;
import com.amazonaws.services.dynamodbv2.model.Condition;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.DeleteGlobalSecondaryIndexAction;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.amazonaws.services.dynamodbv2.model.DeleteRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeStreamResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.GetShardIteratorResult;
import com.amazonaws.services.dynamodbv2.model.ItemCollectionMetrics;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.PutRequest;
import com.amazonaws.services.dynamodbv2.model.Stream;
import com.amazonaws.services.dynamodbv2.model.StreamDescription;
import com.amazonaws.services.dynamodbv2.model.StreamSpecification;
import com.amazonaws.services.dynamodbv2.model.UpdateGlobalSecondaryIndexAction;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import com.amazonaws.services.dynamodbv2.model.UpdateTableResult;
import com.github.dozermapper.core.Mapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.extension.dynamodb.api.attributes.RequestIDAttribute;
import org.mule.extension.dynamodb.api.model.AttributeValue;
import org.mule.extension.dynamodb.api.model.AttributeValueUpdate;
import org.mule.extension.dynamodb.api.model.BatchWriteItemResult;
import org.mule.extension.dynamodb.api.model.ConsumedCapacity;
import org.mule.extension.dynamodb.api.model.CreateGlobalSecondaryIndexAction;
import org.mule.extension.dynamodb.api.model.GlobalSecondaryIndex;
import org.mule.extension.dynamodb.api.model.GlobalSecondaryIndexUpdate;
import org.mule.extension.dynamodb.api.model.Identity;
import org.mule.extension.dynamodb.api.model.KeyType;
import org.mule.extension.dynamodb.api.model.KeysAndAttributes;
import org.mule.extension.dynamodb.api.model.LocalSecondaryIndex;
import org.mule.extension.dynamodb.api.model.OperationType;
import org.mule.extension.dynamodb.api.model.ProvisionedThroughputDescription;
import org.mule.extension.dynamodb.api.model.QueryResult;
import org.mule.extension.dynamodb.api.model.Record;
import org.mule.extension.dynamodb.api.model.ScanResult;
import org.mule.extension.dynamodb.api.model.SequenceNumberRange;
import org.mule.extension.dynamodb.api.model.Shard;
import org.mule.extension.dynamodb.api.model.StreamRecord;
import org.mule.extension.dynamodb.api.model.StreamStatus;
import org.mule.extension.dynamodb.api.model.StreamViewType;
import org.mule.extension.dynamodb.api.model.TableDescription;
import org.mule.extension.dynamodb.api.model.WriteRequest;
import org.mule.extension.dynamodb.internal.util.DateUtils;
import org.mule.extension.dynamodb.internal.util.DozerBeanMapperSingletonWrapper;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;

public final class DynamoDBModelFactory {
    private static final Mapper mapper = DozerBeanMapperSingletonWrapper.getInstance();

    private DynamoDBModelFactory() {
    }

    private static <T> Result<T, RequestIDAttribute> getResult(T payload, AmazonWebServiceResult<ResponseMetadata> amazonWebServiceResult) {
        return DynamoDBModelFactory.getResult(payload, amazonWebServiceResult, null);
    }

    private static <T> Result<T, RequestIDAttribute> getResult(T payload, AmazonWebServiceResult<ResponseMetadata> amazonWebServiceResult, MediaType mediaType) {
        return Result.builder().mediaType(mediaType).output(payload).attributes((Object)new RequestIDAttribute(amazonWebServiceResult.getSdkResponseMetadata().getRequestId())).build();
    }

    public static List<KeySchemaElement> unwrapKeySchemaElementList(Collection<org.mule.extension.dynamodb.api.model.KeySchemaElement> sourceKeySchemaElements) {
        ArrayList<KeySchemaElement> keySchemaElements = null;
        if (sourceKeySchemaElements != null) {
            keySchemaElements = new ArrayList<KeySchemaElement>();
            for (org.mule.extension.dynamodb.api.model.KeySchemaElement keySchemaElement : sourceKeySchemaElements) {
                keySchemaElements.add((KeySchemaElement)mapper.map((Object)keySchemaElement, KeySchemaElement.class));
            }
            return keySchemaElements;
        }
        return keySchemaElements;
    }

    public static List<com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex> unwrapGlobalSecondaryIndexList(Collection<GlobalSecondaryIndex> sourceGlobalSecondaryIndices) {
        ArrayList<com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex> globalSecondaryIndexes = null;
        if (sourceGlobalSecondaryIndices != null) {
            globalSecondaryIndexes = new ArrayList<com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex>();
            for (GlobalSecondaryIndex globalSecondaryIndex : sourceGlobalSecondaryIndices) {
                globalSecondaryIndexes.add(DynamoDBModelFactory.unwrapGlobalSecondaryIndex(globalSecondaryIndex));
            }
            return globalSecondaryIndexes;
        }
        return globalSecondaryIndexes;
    }

    public static com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex unwrapGlobalSecondaryIndex(GlobalSecondaryIndex sourceGlobalSecondaryIndex) {
        com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex globalSecondaryIndex = null;
        if (sourceGlobalSecondaryIndex != null) {
            globalSecondaryIndex = new com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex();
            if (sourceGlobalSecondaryIndex.getIndexName() != null) {
                globalSecondaryIndex.setIndexName(sourceGlobalSecondaryIndex.getIndexName());
            }
            if (sourceGlobalSecondaryIndex.getKeySchema() != null) {
                globalSecondaryIndex.setKeySchema(DynamoDBModelFactory.unwrapKeySchemaElementList(sourceGlobalSecondaryIndex.getKeySchema()));
            }
            if (sourceGlobalSecondaryIndex.getProjection() != null) {
                globalSecondaryIndex.setProjection(DynamoDBModelFactory.unwrapProjection(sourceGlobalSecondaryIndex.getProjection()));
            }
            if (sourceGlobalSecondaryIndex.getProvisionedThroughput() != null) {
                globalSecondaryIndex.setProvisionedThroughput(DynamoDBModelFactory.unwrapProvisionedThroughput(sourceGlobalSecondaryIndex.getProvisionedThroughput()));
            }
        }
        return globalSecondaryIndex;
    }

    public static ProvisionedThroughput unwrapProvisionedThroughput(org.mule.extension.dynamodb.api.model.ProvisionedThroughput sourceProvisionedThroughput) {
        ProvisionedThroughput provisionedThroughput = null;
        if (sourceProvisionedThroughput != null) {
            provisionedThroughput = new ProvisionedThroughput();
            provisionedThroughput.setWriteCapacityUnits(sourceProvisionedThroughput.getWriteCapacityUnits());
            provisionedThroughput.setReadCapacityUnits(sourceProvisionedThroughput.getReadCapacityUnits());
            return provisionedThroughput;
        }
        return provisionedThroughput;
    }

    public static Projection unwrapProjection(org.mule.extension.dynamodb.api.model.Projection sourceProjection) {
        Projection projection = null;
        if (sourceProjection != null) {
            projection = new Projection();
            projection.setNonKeyAttributes(sourceProjection.getNonKeyAttributes());
            projection.setProjectionType(sourceProjection.getProjectionType().toString());
            return projection;
        }
        return projection;
    }

    public static List<com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex> unwrapLocalSecondaryIndexList(Collection<LocalSecondaryIndex> sourceLocalSecondaryIndices) {
        ArrayList<com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex> localSecondaryIndexes = null;
        if (sourceLocalSecondaryIndices != null) {
            localSecondaryIndexes = new ArrayList<com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex>();
            for (LocalSecondaryIndex localSecondaryIndex : sourceLocalSecondaryIndices) {
                localSecondaryIndexes.add(DynamoDBModelFactory.unwrapLocalSecondaryIndex(localSecondaryIndex));
            }
            return localSecondaryIndexes;
        }
        return localSecondaryIndexes;
    }

    public static ProvisionedThroughput getProvisionedThroughput(Long readCapacityUnits, Long writeCapacityUnits) {
        ProvisionedThroughput provisionedThroughput = null;
        if (readCapacityUnits != null || writeCapacityUnits != null) {
            provisionedThroughput = new ProvisionedThroughput();
            if (readCapacityUnits != null) {
                provisionedThroughput.setReadCapacityUnits(readCapacityUnits);
            }
            if (writeCapacityUnits != null) {
                provisionedThroughput.setWriteCapacityUnits(writeCapacityUnits);
            }
        }
        return provisionedThroughput;
    }

    public static com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex unwrapLocalSecondaryIndex(LocalSecondaryIndex sourceLocalSecondaryIndex) {
        com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex localSecondaryIndex = null;
        if (sourceLocalSecondaryIndex != null) {
            localSecondaryIndex = new com.amazonaws.services.dynamodbv2.model.LocalSecondaryIndex();
            if (sourceLocalSecondaryIndex.getIndexName() != null) {
                localSecondaryIndex.setIndexName(sourceLocalSecondaryIndex.getIndexName());
            }
            if (sourceLocalSecondaryIndex.getKeySchema() != null) {
                localSecondaryIndex.setKeySchema(DynamoDBModelFactory.unwrapKeySchemaElementList(sourceLocalSecondaryIndex.getKeySchema()));
            }
            if (sourceLocalSecondaryIndex.getProjection() != null) {
                localSecondaryIndex.setProjection(DynamoDBModelFactory.unwrapProjection(sourceLocalSecondaryIndex.getProjection()));
            }
        }
        return localSecondaryIndex;
    }

    public static StreamSpecification unwrapgetStreamSpecication(StreamViewType streamViewType, boolean streamEnabled) {
        StreamSpecification streamSpecification = null;
        if (streamViewType != null) {
            streamSpecification = new StreamSpecification();
            streamSpecification.setStreamViewType(streamViewType.toString());
            streamSpecification.setStreamEnabled(Boolean.valueOf(streamEnabled));
            return streamSpecification;
        }
        return streamSpecification;
    }

    public static List<com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexUpdate> unwrapGlobalSecondaryIndexUpdates(Collection<GlobalSecondaryIndexUpdate> sourceGlobalSecondaryIndexUpdates) {
        ArrayList<com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates = null;
        if (sourceGlobalSecondaryIndexUpdates != null) {
            globalSecondaryIndexUpdates = new ArrayList<com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexUpdate>();
            for (GlobalSecondaryIndexUpdate sourceGlobalSecondaryIndexUpdate : sourceGlobalSecondaryIndexUpdates) {
                com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexUpdate globalSecondaryIndexUpdate = new com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexUpdate();
                if (sourceGlobalSecondaryIndexUpdate.getCreate() != null) {
                    globalSecondaryIndexUpdate.setCreate(DynamoDBModelFactory.unwrapCreateGlobalSecondaryAction(sourceGlobalSecondaryIndexUpdate.getCreate()));
                }
                if (sourceGlobalSecondaryIndexUpdate.getUpdate() != null) {
                    globalSecondaryIndexUpdate.setUpdate(DynamoDBModelFactory.unwrapUpdateGlobalSecondaryAction(sourceGlobalSecondaryIndexUpdate.getUpdate()));
                }
                if (sourceGlobalSecondaryIndexUpdate.getDelete() != null) {
                    globalSecondaryIndexUpdate.setDelete(new DeleteGlobalSecondaryIndexAction().withIndexName(sourceGlobalSecondaryIndexUpdate.getDelete()));
                }
                globalSecondaryIndexUpdates.add(globalSecondaryIndexUpdate);
            }
            return globalSecondaryIndexUpdates;
        }
        return globalSecondaryIndexUpdates;
    }

    public static com.amazonaws.services.dynamodbv2.model.CreateGlobalSecondaryIndexAction unwrapCreateGlobalSecondaryAction(CreateGlobalSecondaryIndexAction input) {
        com.amazonaws.services.dynamodbv2.model.CreateGlobalSecondaryIndexAction createGlobalSecondaryIndexAction = null;
        if (input != null) {
            createGlobalSecondaryIndexAction = new com.amazonaws.services.dynamodbv2.model.CreateGlobalSecondaryIndexAction().withIndexName(input.getIndexName()).withKeySchema(DynamoDBModelFactory.unwrapKeySchemaElementList(input.getKeySchema())).withProvisionedThroughput(DynamoDBModelFactory.unwrapProvisionedThroughput(input.getProvisionedThroughput())).withProjection(DynamoDBModelFactory.unwrapProjection(input.getProjection()));
        }
        return createGlobalSecondaryIndexAction;
    }

    public static Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> unwrapKey(Map<String, AttributeValue> item) {
        HashMap<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> toItem = null;
        if (item != null) {
            toItem = new HashMap<String, com.amazonaws.services.dynamodbv2.model.AttributeValue>();
            for (Map.Entry<String, AttributeValue> entry : item.entrySet()) {
                toItem.put(entry.getKey(), DynamoDBModelFactory.unWrapAttributeValue(entry.getValue()));
            }
        }
        return toItem;
    }

    public static Collection<com.amazonaws.services.dynamodbv2.model.AttributeValue> unWrapAttributeValueList(List<AttributeValue> attributeValueList) {
        ArrayList<com.amazonaws.services.dynamodbv2.model.AttributeValue> awsAttributeValues = null;
        if (attributeValueList != null) {
            awsAttributeValues = new ArrayList<com.amazonaws.services.dynamodbv2.model.AttributeValue>();
            for (AttributeValue value : attributeValueList) {
                awsAttributeValues.add(DynamoDBModelFactory.unWrapAttributeValue(value));
            }
        }
        return awsAttributeValues;
    }

    public static com.amazonaws.services.dynamodbv2.model.AttributeValue unWrapAttributeValue(AttributeValue attributeValue) {
        com.amazonaws.services.dynamodbv2.model.AttributeValue toAttribute = null;
        if (attributeValue != null) {
            toAttribute = new com.amazonaws.services.dynamodbv2.model.AttributeValue().withB(attributeValue.getB()).withBOOL(attributeValue.getBool()).withBS(attributeValue.getBs()).withL(DynamoDBModelFactory.unWrapAttributeValueList(attributeValue.getL())).withM(DynamoDBModelFactory.unwrapKey(attributeValue.getM())).withN(attributeValue.getN()).withNS(attributeValue.getNs()).withNULL(attributeValue.getNullvalue()).withS(attributeValue.getS()).withSS(attributeValue.getSs());
        }
        return toAttribute;
    }

    public static Map<String, com.amazonaws.services.dynamodbv2.model.KeysAndAttributes> unwrapRequestItems(Map<String, KeysAndAttributes> sourcerequestItems) {
        HashMap<String, com.amazonaws.services.dynamodbv2.model.KeysAndAttributes> requestItems = null;
        if (sourcerequestItems != null) {
            requestItems = new HashMap<String, com.amazonaws.services.dynamodbv2.model.KeysAndAttributes>();
            for (Map.Entry<String, KeysAndAttributes> entryItem : sourcerequestItems.entrySet()) {
                requestItems.put(entryItem.getKey(), DynamoDBModelFactory.unWrapKeysAndAttributes(entryItem.getValue()));
            }
        }
        return requestItems;
    }

    public static com.amazonaws.services.dynamodbv2.model.KeysAndAttributes unWrapKeysAndAttributes(KeysAndAttributes sourceKeysAndAttributes) {
        com.amazonaws.services.dynamodbv2.model.KeysAndAttributes keysAndAttributes = null;
        if (sourceKeysAndAttributes != null) {
            keysAndAttributes = new com.amazonaws.services.dynamodbv2.model.KeysAndAttributes();
            if (sourceKeysAndAttributes.getAttributesToGet() != null) {
                keysAndAttributes.setAttributesToGet(sourceKeysAndAttributes.getAttributesToGet());
            }
            keysAndAttributes.setConsistentRead(Boolean.valueOf(sourceKeysAndAttributes.isConsistentRead()));
            if (sourceKeysAndAttributes.getExpressionAttributeNames() != null) {
                keysAndAttributes.setExpressionAttributeNames(sourceKeysAndAttributes.getExpressionAttributeNames());
            }
            if (sourceKeysAndAttributes.getKeys() != null) {
                keysAndAttributes.setKeys(DynamoDBModelFactory.unwrapGetListKeys(sourceKeysAndAttributes.getKeys()));
            }
            if (sourceKeysAndAttributes.getProjectionExpression() != null) {
                keysAndAttributes.setProjectionExpression(sourceKeysAndAttributes.getProjectionExpression());
            }
            return keysAndAttributes;
        }
        return keysAndAttributes;
    }

    public static List<Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue>> unwrapGetListKeys(List<Map<String, AttributeValue>> sourceListKeys) {
        ArrayList<Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue>> listKeys = null;
        if (sourceListKeys != null) {
            listKeys = new ArrayList<Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue>>();
            for (Map<String, AttributeValue> item : sourceListKeys) {
                if (item == null) continue;
                listKeys.add(DynamoDBModelFactory.unwrapKey(item));
            }
            return listKeys;
        }
        return listKeys;
    }

    public static Map<String, Condition> unwrapKeyConditionsorFilters(Map<String, org.mule.extension.dynamodb.api.model.Condition> sourceKeyConditionsorQueryFilter) {
        HashMap<String, Condition> stringConditionMap = null;
        if (sourceKeyConditionsorQueryFilter != null) {
            stringConditionMap = new HashMap<String, Condition>();
            for (Map.Entry<String, org.mule.extension.dynamodb.api.model.Condition> entryItem : sourceKeyConditionsorQueryFilter.entrySet()) {
                stringConditionMap.put(entryItem.getKey(), DynamoDBModelFactory.unwrapCondition(entryItem.getValue()));
            }
            return stringConditionMap;
        }
        return stringConditionMap;
    }

    public static Condition unwrapCondition(org.mule.extension.dynamodb.api.model.Condition sourceCondition) {
        Condition condition = null;
        if (sourceCondition != null) {
            condition = new Condition();
            condition.setAttributeValueList(DynamoDBModelFactory.unWrapAttributeValueList(sourceCondition.getAttributeValueList()));
            condition.setComparisonOperator(sourceCondition.getComparisonOperator().toString());
            return condition;
        }
        return condition;
    }

    public static Result<org.mule.extension.dynamodb.api.model.GetItemResult, RequestIDAttribute> wrap(GetItemResult sourcegetItemResult) {
        org.mule.extension.dynamodb.api.model.GetItemResult getItemResult = new org.mule.extension.dynamodb.api.model.GetItemResult(DynamoDBModelFactory.wrapStringAttributeValueMap(sourcegetItemResult.getItem()), DynamoDBModelFactory.wrapConsumeCapacity(sourcegetItemResult.getConsumedCapacity()));
        return DynamoDBModelFactory.getResult(getItemResult, (AmazonWebServiceResult<ResponseMetadata>)sourcegetItemResult);
    }

    public static UpdateGlobalSecondaryIndexAction unwrapUpdateGlobalSecondaryAction(org.mule.extension.dynamodb.api.model.UpdateGlobalSecondaryIndexAction sourceUpdateGlobalSecondaryIndexAction) {
        return (UpdateGlobalSecondaryIndexAction)mapper.map((Object)sourceUpdateGlobalSecondaryIndexAction, UpdateGlobalSecondaryIndexAction.class);
    }

    public static Result<TableDescription, RequestIDAttribute> wrapCreateTable(CreateTableResult source) {
        TableDescription input = (TableDescription)mapper.map((Object)source.getTableDescription(), TableDescription.class);
        TableDescription result = new TableDescription(input.getAttributeDefinitions(), input.getTableName(), input.getKeySchema(), input.getTableStatus(), DateUtils.toLocalDateTime(source.getTableDescription().getCreationDateTime()), DynamoDBModelFactory.getProvisionedThroughputwithLocalDate(input.getProvisionedThroughput(), source.getTableDescription().getProvisionedThroughput()), input.getTableSizeBytes(), input.getItemCount(), input.getTableArn(), input.getLocalSecondaryIndexes(), input.getGlobalSecondaryIndexes(), input.getStreamSpecification(), input.getLatestStreamLabel(), input.getLatestStreamArn());
        return DynamoDBModelFactory.getResult(result, (AmazonWebServiceResult<ResponseMetadata>)source);
    }

    public static ProvisionedThroughputDescription getProvisionedThroughputwithLocalDate(ProvisionedThroughputDescription targetProvisionedThroughputDescription, com.amazonaws.services.dynamodbv2.model.ProvisionedThroughputDescription sourceProvisionedThroughput) {
        return new ProvisionedThroughputDescription(DateUtils.toLocalDateTime(sourceProvisionedThroughput.getLastDecreaseDateTime()), DateUtils.toLocalDateTime(sourceProvisionedThroughput.getLastIncreaseDateTime()), targetProvisionedThroughputDescription.getNumberOfDecreasesToday(), targetProvisionedThroughputDescription.getReadCapacityUnits(), targetProvisionedThroughputDescription.getWriteCapacityUnits());
    }

    public static Result<TableDescription, RequestIDAttribute> wrapDeleteTable(DeleteTableResult source) {
        TableDescription input = (TableDescription)mapper.map((Object)source.getTableDescription(), TableDescription.class);
        TableDescription result = new TableDescription(input.getAttributeDefinitions(), input.getTableName(), input.getKeySchema(), input.getTableStatus(), DateUtils.toLocalDateTime(source.getTableDescription().getCreationDateTime()), DynamoDBModelFactory.getProvisionedThroughputwithLocalDate(input.getProvisionedThroughput(), source.getTableDescription().getProvisionedThroughput()), input.getTableSizeBytes(), input.getItemCount(), input.getTableArn(), input.getLocalSecondaryIndexes(), input.getGlobalSecondaryIndexes(), input.getStreamSpecification(), input.getLatestStreamLabel(), input.getLatestStreamArn());
        return DynamoDBModelFactory.getResult(result, (AmazonWebServiceResult<ResponseMetadata>)source);
    }

    public static Result<TableDescription, RequestIDAttribute> wrapDescribeTable(DescribeTableResult source) {
        TableDescription input = (TableDescription)mapper.map((Object)source.getTable(), TableDescription.class);
        TableDescription result = new TableDescription(input.getAttributeDefinitions(), input.getTableName(), input.getKeySchema(), input.getTableStatus(), DateUtils.toLocalDateTime(source.getTable().getCreationDateTime()), DynamoDBModelFactory.getProvisionedThroughputwithLocalDate(input.getProvisionedThroughput(), source.getTable().getProvisionedThroughput()), input.getTableSizeBytes(), input.getItemCount(), input.getTableArn(), input.getLocalSecondaryIndexes(), input.getGlobalSecondaryIndexes(), input.getStreamSpecification(), input.getLatestStreamLabel(), input.getLatestStreamArn());
        return DynamoDBModelFactory.getResult(result, (AmazonWebServiceResult<ResponseMetadata>)source);
    }

    public static Result<org.mule.extension.dynamodb.api.model.ListTablesResult, RequestIDAttribute> wrap(ListTablesResult sourceListTablesResult) {
        return DynamoDBModelFactory.getResult(mapper.map((Object)sourceListTablesResult, org.mule.extension.dynamodb.api.model.ListTablesResult.class), (AmazonWebServiceResult<ResponseMetadata>)sourceListTablesResult);
    }

    public static Result<TableDescription, RequestIDAttribute> wrapUpdateTable(UpdateTableResult source) {
        TableDescription input = (TableDescription)mapper.map((Object)source.getTableDescription(), TableDescription.class);
        TableDescription result = new TableDescription(input.getAttributeDefinitions(), input.getTableName(), input.getKeySchema(), input.getTableStatus(), DateUtils.toLocalDateTime(source.getTableDescription().getCreationDateTime()), DynamoDBModelFactory.getProvisionedThroughputwithLocalDate(input.getProvisionedThroughput(), source.getTableDescription().getProvisionedThroughput()), input.getTableSizeBytes(), input.getItemCount(), input.getTableArn(), input.getLocalSecondaryIndexes(), input.getGlobalSecondaryIndexes(), input.getStreamSpecification(), input.getLatestStreamLabel(), input.getLatestStreamArn());
        return DynamoDBModelFactory.getResult(result, (AmazonWebServiceResult<ResponseMetadata>)source);
    }

    public static Result<org.mule.extension.dynamodb.api.model.PutItemResult, RequestIDAttribute> wrap(PutItemResult sourceputItemResult) {
        org.mule.extension.dynamodb.api.model.PutItemResult result = (org.mule.extension.dynamodb.api.model.PutItemResult)mapper.map((Object)sourceputItemResult, org.mule.extension.dynamodb.api.model.PutItemResult.class);
        return DynamoDBModelFactory.getResult(result, (AmazonWebServiceResult<ResponseMetadata>)sourceputItemResult);
    }

    public static Result<org.mule.extension.dynamodb.api.model.DeleteItemResult, RequestIDAttribute> wrap(DeleteItemResult sourcedeleteItemResult) {
        org.mule.extension.dynamodb.api.model.DeleteItemResult result = (org.mule.extension.dynamodb.api.model.DeleteItemResult)mapper.map((Object)sourcedeleteItemResult, org.mule.extension.dynamodb.api.model.DeleteItemResult.class);
        return DynamoDBModelFactory.getResult(result, (AmazonWebServiceResult<ResponseMetadata>)sourcedeleteItemResult);
    }

    public static Result<org.mule.extension.dynamodb.api.model.BatchGetItemResult, RequestIDAttribute> wrap(BatchGetItemResult sourceBatchGetItemResult) {
        org.mule.extension.dynamodb.api.model.BatchGetItemResult batchGetItemResult = new org.mule.extension.dynamodb.api.model.BatchGetItemResult(DynamoDBModelFactory.wrapResponses(sourceBatchGetItemResult.getResponses()), DynamoDBModelFactory.wrapUnprocessedKeys(sourceBatchGetItemResult.getUnprocessedKeys()), DynamoDBModelFactory.wrapConsumedCapacityList(sourceBatchGetItemResult.getConsumedCapacity()));
        return DynamoDBModelFactory.getResult(batchGetItemResult, (AmazonWebServiceResult<ResponseMetadata>)sourceBatchGetItemResult);
    }

    public static Map<String, KeysAndAttributes> wrapUnprocessedKeys(Map<String, com.amazonaws.services.dynamodbv2.model.KeysAndAttributes> sourceKeysAndAttributesMap) {
        HashMap<String, KeysAndAttributes> destKeysAndAttributesMap = null;
        if (sourceKeysAndAttributesMap != null) {
            destKeysAndAttributesMap = new HashMap<String, KeysAndAttributes>();
            for (Map.Entry<String, com.amazonaws.services.dynamodbv2.model.KeysAndAttributes> sourceItem : sourceKeysAndAttributesMap.entrySet()) {
                destKeysAndAttributesMap.put(sourceItem.getKey(), DynamoDBModelFactory.wrapKeysandAttributes(sourceItem.getValue()));
            }
            return destKeysAndAttributesMap;
        }
        return destKeysAndAttributesMap;
    }

    public static KeysAndAttributes wrapKeysandAttributes(com.amazonaws.services.dynamodbv2.model.KeysAndAttributes sourceKeysAndAttributes) {
        if (sourceKeysAndAttributes != null) {
            return new KeysAndAttributes(DynamoDBModelFactory.wrapItemsResult(sourceKeysAndAttributes.getKeys()), sourceKeysAndAttributes.getAttributesToGet(), sourceKeysAndAttributes.getConsistentRead(), sourceKeysAndAttributes.getProjectionExpression(), sourceKeysAndAttributes.getExpressionAttributeNames());
        }
        return null;
    }

    public static Map<String, List<Map<String, AttributeValue>>> wrapResponses(Map<String, List<Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue>>> sourceResponses) {
        HashMap<String, List<Map<String, AttributeValue>>> destResponses = null;
        if (sourceResponses != null) {
            destResponses = new HashMap<String, List<Map<String, AttributeValue>>>();
            for (Map.Entry<String, List<Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue>>> sourceItem : sourceResponses.entrySet()) {
                destResponses.put(sourceItem.getKey(), DynamoDBModelFactory.wrapItemsResult(sourceItem.getValue()));
            }
            return destResponses;
        }
        return destResponses;
    }

    public static List<ConsumedCapacity> wrapConsumedCapacityList(List<com.amazonaws.services.dynamodbv2.model.ConsumedCapacity> sourceconsumedCapacities) {
        ArrayList<ConsumedCapacity> consumedCapacities = null;
        if (sourceconsumedCapacities != null) {
            consumedCapacities = new ArrayList<ConsumedCapacity>();
            for (com.amazonaws.services.dynamodbv2.model.ConsumedCapacity consumedCapacity : sourceconsumedCapacities) {
                consumedCapacities.add(DynamoDBModelFactory.wrapConsumeCapacity(consumedCapacity));
            }
            return consumedCapacities;
        }
        return consumedCapacities;
    }

    public static Result<QueryResult, RequestIDAttribute> wrap(com.amazonaws.services.dynamodbv2.model.QueryResult sourceQueryResult) {
        return DynamoDBModelFactory.getResult(new QueryResult(DynamoDBModelFactory.wrapItemsResult(sourceQueryResult.getItems()), sourceQueryResult.getCount(), sourceQueryResult.getScannedCount(), DynamoDBModelFactory.wrapStringAttributeValueMap(sourceQueryResult.getLastEvaluatedKey()), DynamoDBModelFactory.wrapConsumeCapacity(sourceQueryResult.getConsumedCapacity())), (AmazonWebServiceResult<ResponseMetadata>)sourceQueryResult);
    }

    public static Result<List<Map<String, AttributeValue>>, RequestIDAttribute> wrapPaginatedResult(com.amazonaws.services.dynamodbv2.model.QueryResult sourceQueryResult) {
        return DynamoDBModelFactory.getResult(DynamoDBModelFactory.wrapItemsResult(sourceQueryResult.getItems()), (AmazonWebServiceResult<ResponseMetadata>)sourceQueryResult);
    }

    public static List<Map<String, AttributeValue>> wrapItemsResult(List<Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue>> sourceItems) {
        ArrayList<Map<String, AttributeValue>> resultItems = null;
        if (sourceItems != null) {
            resultItems = new ArrayList<Map<String, AttributeValue>>();
            for (Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> attributeValueMap : sourceItems) {
                resultItems.add(DynamoDBModelFactory.wrapStringAttributeValueMap(attributeValueMap));
            }
            return resultItems;
        }
        return resultItems;
    }

    public static ConsumedCapacity wrapConsumeCapacity(com.amazonaws.services.dynamodbv2.model.ConsumedCapacity sourceConsumedCapacity) {
        if (sourceConsumedCapacity != null) {
            return new ConsumedCapacity(sourceConsumedCapacity.getTableName(), sourceConsumedCapacity.getCapacityUnits(), null, DynamoDBModelFactory.unwrapIndexes(sourceConsumedCapacity.getLocalSecondaryIndexes()), DynamoDBModelFactory.unwrapIndexes(sourceConsumedCapacity.getGlobalSecondaryIndexes()));
        }
        return null;
    }

    public static Map<String, Double> unwrapIndexes(Map<String, Capacity> sourceIndexes) {
        HashMap<String, Double> mapIndexes = null;
        if (sourceIndexes != null) {
            mapIndexes = new HashMap<String, Double>();
            for (Map.Entry<String, Capacity> sourceItem : sourceIndexes.entrySet()) {
                mapIndexes.put(sourceItem.getKey(), DynamoDBModelFactory.unwrapCapacity(sourceItem.getValue()));
            }
        }
        return mapIndexes;
    }

    public static Double unwrapCapacity(Capacity sourceCapacity) {
        return Optional.ofNullable(sourceCapacity).map(Capacity::getCapacityUnits).orElse(null);
    }

    public static Map<String, AttributeValue> wrapStringAttributeValueMap(Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> item) {
        HashMap<String, AttributeValue> toItem = null;
        if (item != null) {
            toItem = new HashMap<String, AttributeValue>();
            for (Map.Entry<String, com.amazonaws.services.dynamodbv2.model.AttributeValue> entry : item.entrySet()) {
                toItem.put(entry.getKey(), DynamoDBModelFactory.wrapAttributeValueResult(entry.getValue()));
            }
        }
        return toItem;
    }

    public static AttributeValue wrapAttributeValueResult(com.amazonaws.services.dynamodbv2.model.AttributeValue attributeValue) {
        if (attributeValue != null) {
            return new AttributeValue(attributeValue.getS(), attributeValue.getN(), attributeValue.getB(), attributeValue.getSS(), attributeValue.getNS(), attributeValue.getBS(), DynamoDBModelFactory.wrapStringAttributeValueMap(attributeValue.getM()), DynamoDBModelFactory.unWrapAttributeValueListResult(attributeValue.getL()), attributeValue.getNULL(), attributeValue.getBOOL());
        }
        return null;
    }

    public static List<AttributeValue> unWrapAttributeValueListResult(List<com.amazonaws.services.dynamodbv2.model.AttributeValue> attributeValueList) {
        ArrayList<AttributeValue> attributeValues = null;
        if (attributeValueList != null) {
            attributeValues = new ArrayList<AttributeValue>();
            for (com.amazonaws.services.dynamodbv2.model.AttributeValue value : attributeValueList) {
                attributeValues.add(DynamoDBModelFactory.wrapAttributeValueResult(value));
            }
        }
        return attributeValues;
    }

    public static Result<ScanResult, RequestIDAttribute> wrap(com.amazonaws.services.dynamodbv2.model.ScanResult sourceScanResult) {
        return DynamoDBModelFactory.getResult(new ScanResult(DynamoDBModelFactory.wrapItemsResult(sourceScanResult.getItems()), sourceScanResult.getCount(), sourceScanResult.getScannedCount(), DynamoDBModelFactory.wrapStringAttributeValueMap(sourceScanResult.getLastEvaluatedKey()), DynamoDBModelFactory.wrapConsumeCapacity(sourceScanResult.getConsumedCapacity())), (AmazonWebServiceResult<ResponseMetadata>)sourceScanResult);
    }

    public static Map<String, ExpectedAttributeValue> unwrapExpected(Map<String, org.mule.extension.dynamodb.api.model.ExpectedAttributeValue> sourceExpectedAttributeValueMap) {
        HashMap<String, ExpectedAttributeValue> expectedAttributeValueMap = null;
        if (sourceExpectedAttributeValueMap != null) {
            expectedAttributeValueMap = new HashMap<String, ExpectedAttributeValue>();
            for (Map.Entry<String, org.mule.extension.dynamodb.api.model.ExpectedAttributeValue> sourceItem : sourceExpectedAttributeValueMap.entrySet()) {
                expectedAttributeValueMap.put(sourceItem.getKey(), DynamoDBModelFactory.unwrapExpectedAttributeValue(sourceItem.getValue()));
            }
        }
        return expectedAttributeValueMap;
    }

    public static ExpectedAttributeValue unwrapExpectedAttributeValue(org.mule.extension.dynamodb.api.model.ExpectedAttributeValue sourceExpectedAttributeValue) {
        ExpectedAttributeValue expectedAttributeValue = null;
        if (sourceExpectedAttributeValue != null) {
            expectedAttributeValue = new ExpectedAttributeValue();
            expectedAttributeValue.setAttributeValueList(DynamoDBModelFactory.unWrapAttributeValueList(sourceExpectedAttributeValue.getAttributeValueList()));
            expectedAttributeValue.setComparisonOperator(sourceExpectedAttributeValue.getComparisonOperator().toString());
            expectedAttributeValue.setExists(Boolean.valueOf(sourceExpectedAttributeValue.isExists()));
            expectedAttributeValue.setValue(DynamoDBModelFactory.unWrapAttributeValue(sourceExpectedAttributeValue.getValue()));
            return expectedAttributeValue;
        }
        return expectedAttributeValue;
    }

    public static Map<String, com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate> unwrapAttributeValueUpdate(Map<String, AttributeValueUpdate> sourceAttributeValueUpdateMap) {
        HashMap<String, com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate> attributeValueUpdateMap = null;
        if (sourceAttributeValueUpdateMap != null) {
            attributeValueUpdateMap = new HashMap<String, com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate>();
            for (Map.Entry<String, AttributeValueUpdate> sourceItem : sourceAttributeValueUpdateMap.entrySet()) {
                attributeValueUpdateMap.put(sourceItem.getKey(), DynamoDBModelFactory.unwrapgetAttributeValueUpdte(sourceItem.getValue()));
            }
            return attributeValueUpdateMap;
        }
        return attributeValueUpdateMap;
    }

    public static com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate unwrapgetAttributeValueUpdte(AttributeValueUpdate sourceAttributeValueUpdate) {
        com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate attributeValueUpdate = null;
        if (sourceAttributeValueUpdate != null) {
            attributeValueUpdate = new com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate();
            attributeValueUpdate.setAction(sourceAttributeValueUpdate.getAction().toString());
            attributeValueUpdate.setValue(DynamoDBModelFactory.unWrapAttributeValue(sourceAttributeValueUpdate.getValue()));
            return attributeValueUpdate;
        }
        return attributeValueUpdate;
    }

    public static Result<org.mule.extension.dynamodb.api.model.UpdateItemResult, RequestIDAttribute> updateItem(UpdateItemResult sourceUpdateItemResult) {
        org.mule.extension.dynamodb.api.model.UpdateItemResult updateItemResult = new org.mule.extension.dynamodb.api.model.UpdateItemResult(DynamoDBModelFactory.wrapStringAttributeValueMap(sourceUpdateItemResult.getAttributes()), DynamoDBModelFactory.wrapConsumeCapacity(sourceUpdateItemResult.getConsumedCapacity()), DynamoDBModelFactory.wrapItemCollectionMetrics(sourceUpdateItemResult.getItemCollectionMetrics()));
        return DynamoDBModelFactory.getResult(updateItemResult, (AmazonWebServiceResult<ResponseMetadata>)sourceUpdateItemResult);
    }

    public static org.mule.extension.dynamodb.api.model.ItemCollectionMetrics wrapItemCollectionMetrics(ItemCollectionMetrics sourceItemCollectionMetrics) {
        if (sourceItemCollectionMetrics != null) {
            return new org.mule.extension.dynamodb.api.model.ItemCollectionMetrics(DynamoDBModelFactory.wrapStringAttributeValueMap(sourceItemCollectionMetrics.getItemCollectionKey()), sourceItemCollectionMetrics.getSizeEstimateRangeGB());
        }
        return null;
    }

    public static Result<BatchWriteItemResult, RequestIDAttribute> wrap(com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult source) {
        BatchWriteItemResult result = (BatchWriteItemResult)mapper.map((Object)source, BatchWriteItemResult.class);
        return DynamoDBModelFactory.getResult(result, (AmazonWebServiceResult<ResponseMetadata>)source);
    }

    public static Map<String, List<com.amazonaws.services.dynamodbv2.model.WriteRequest>> unwrapRequestPutItem(Map<String, List<WriteRequest>> source) {
        HashMap<String, List<com.amazonaws.services.dynamodbv2.model.WriteRequest>> requestPutItems = null;
        if (source != null) {
            requestPutItems = new HashMap<String, List<com.amazonaws.services.dynamodbv2.model.WriteRequest>>();
            for (Map.Entry<String, List<WriteRequest>> entry : source.entrySet()) {
                requestPutItems.put(entry.getKey(), DynamoDBModelFactory.unWrapWriteRequestList(entry.getValue()));
            }
        }
        return requestPutItems;
    }

    public static List<com.amazonaws.services.dynamodbv2.model.WriteRequest> unWrapWriteRequestList(List<WriteRequest> source) {
        ArrayList<com.amazonaws.services.dynamodbv2.model.WriteRequest> writeRequests = null;
        if (source != null) {
            writeRequests = new ArrayList<com.amazonaws.services.dynamodbv2.model.WriteRequest>();
            for (WriteRequest request : source) {
                com.amazonaws.services.dynamodbv2.model.WriteRequest destination = new com.amazonaws.services.dynamodbv2.model.WriteRequest();
                if (request.getDeleteRequest() == null) {
                    destination.setDeleteRequest(null);
                } else {
                    destination.setDeleteRequest(new DeleteRequest().withKey(DynamoDBModelFactory.unwrapKey(request.getDeleteRequest())));
                }
                if (request.getPutRequest() == null) {
                    destination.setPutRequest(null);
                } else {
                    destination.setPutRequest(new PutRequest().withItem(DynamoDBModelFactory.unwrapKey(request.getPutRequest())));
                }
                writeRequests.add(destination);
            }
        }
        return writeRequests;
    }

    public static org.mule.extension.dynamodb.api.model.Stream wrapStream(Stream source) {
        return source != null ? new org.mule.extension.dynamodb.api.model.Stream(source.getStreamArn(), source.getTableName(), source.getStreamLabel()) : new org.mule.extension.dynamodb.api.model.Stream();
    }

    public static Record wrapRecord(com.amazonaws.services.dynamodbv2.model.Record source) {
        return source != null ? new Record(source.getEventID(), OperationType.valueOf(source.getEventName()), source.getEventVersion(), source.getEventSource(), source.getAwsRegion(), DynamoDBModelFactory.wrapStreamRecord(source.getDynamodb()), DynamoDBModelFactory.wrapUserIdentity(source.getUserIdentity())) : new Record();
    }

    public static StreamRecord wrapStreamRecord(com.amazonaws.services.dynamodbv2.model.StreamRecord source) {
        return source != null ? new StreamRecord(DateUtils.toLocalDateTime(source.getApproximateCreationDateTime()), DynamoDBModelFactory.wrapStringAttributeValueMap(source.getKeys()), DynamoDBModelFactory.wrapStringAttributeValueMap(source.getNewImage()), DynamoDBModelFactory.wrapStringAttributeValueMap(source.getOldImage()), source.getSequenceNumber(), source.getSizeBytes(), StreamViewType.valueOf(source.getStreamViewType())) : new StreamRecord();
    }

    public static Identity wrapUserIdentity(com.amazonaws.services.dynamodbv2.model.Identity source) {
        return source != null ? new Identity(source.getPrincipalId(), source.getType()) : new Identity();
    }

    public static Result<org.mule.extension.dynamodb.api.model.StreamDescription, RequestIDAttribute> describeStream(DescribeStreamResult sourceResult) {
        StreamDescription source = sourceResult.getStreamDescription();
        return DynamoDBModelFactory.getResult(source != null ? new org.mule.extension.dynamodb.api.model.StreamDescription(source.getStreamArn(), source.getStreamLabel(), StreamStatus.valueOf(source.getStreamStatus()), StreamViewType.valueOf(source.getStreamViewType()), DateUtils.toLocalDateTime(source.getCreationRequestDateTime()), source.getTableName(), DynamoDBModelFactory.wrapKeySchemaElementList(source.getKeySchema()), DynamoDBModelFactory.wrapShardsList(source.getShards()), source.getLastEvaluatedShardId()) : new org.mule.extension.dynamodb.api.model.StreamDescription(), (AmazonWebServiceResult<ResponseMetadata>)sourceResult);
    }

    public static List<org.mule.extension.dynamodb.api.model.KeySchemaElement> wrapKeySchemaElementList(List<KeySchemaElement> source) {
        ArrayList<org.mule.extension.dynamodb.api.model.KeySchemaElement> keySchemaElements = new ArrayList<org.mule.extension.dynamodb.api.model.KeySchemaElement>();
        if (source != null) {
            for (KeySchemaElement element : source) {
                keySchemaElements.add(DynamoDBModelFactory.wrapKeySchemaElement(element));
            }
        }
        return keySchemaElements;
    }

    public static org.mule.extension.dynamodb.api.model.KeySchemaElement wrapKeySchemaElement(KeySchemaElement source) {
        return source != null ? new org.mule.extension.dynamodb.api.model.KeySchemaElement(source.getAttributeName(), KeyType.valueOf(source.getKeyType())) : new org.mule.extension.dynamodb.api.model.KeySchemaElement();
    }

    public static List<Shard> wrapShardsList(List<com.amazonaws.services.dynamodbv2.model.Shard> source) {
        ArrayList<Shard> shards = new ArrayList<Shard>();
        if (source != null) {
            for (com.amazonaws.services.dynamodbv2.model.Shard shard : source) {
                shards.add(DynamoDBModelFactory.wrapShard(shard));
            }
        }
        return shards;
    }

    public static Shard wrapShard(com.amazonaws.services.dynamodbv2.model.Shard source) {
        return source != null ? new Shard(source.getShardId(), DynamoDBModelFactory.wrapSequenceNumberRange(source.getSequenceNumberRange()), source.getParentShardId()) : new Shard();
    }

    public static SequenceNumberRange wrapSequenceNumberRange(com.amazonaws.services.dynamodbv2.model.SequenceNumberRange source) {
        return source != null ? new SequenceNumberRange(source.getStartingSequenceNumber(), source.getEndingSequenceNumber()) : new SequenceNumberRange();
    }

    public static Result<String, RequestIDAttribute> getShardIterator(GetShardIteratorResult source) {
        return DynamoDBModelFactory.getResult(source.getShardIterator(), (AmazonWebServiceResult<ResponseMetadata>)source, MediaType.TEXT);
    }
}

