/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.dynamodb.internal.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Date;
import java.util.Optional;

public final class DateUtils {
    private DateUtils() {
    }

    public static LocalDate toLocalDate(Date date) {
        return DateUtils.toLocalDate(date, ZoneId.systemDefault());
    }

    public static LocalDate toLocalDate(Date date, ZoneId zoneId) {
        return Optional.ofNullable(date).map(value -> DateUtils.toZonedDateTime(date, zoneId).toLocalDate()).orElse(null);
    }

    public static LocalTime toLocalTime(Date date) {
        return DateUtils.toLocalTime(date, ZoneId.systemDefault());
    }

    public static LocalTime toLocalTime(Date date, ZoneId zoneId) {
        return Optional.ofNullable(date).map(value -> DateUtils.toZonedDateTime(date, zoneId).toLocalTime()).orElse(null);
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        return DateUtils.toLocalDateTime(date, ZoneId.systemDefault());
    }

    public static LocalDateTime toLocalDateTime(Date date, ZoneId zoneId) {
        return Optional.ofNullable(date).map(value -> DateUtils.toZonedDateTime(date, zoneId).toLocalDateTime()).orElse(null);
    }

    public static ZonedDateTime toZonedDateTime(Date date, ZoneId zoneId) {
        return date.toInstant().atZone(zoneId);
    }

    public static Date toDate(LocalDateTime localDateTime) {
        return Optional.ofNullable(localDateTime).map(value -> value.atZone(ZoneId.systemDefault())).map(ChronoZonedDateTime::toInstant).map(Date::from).orElse(null);
    }
}

