/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.dynamodb.internal.util;

import com.github.dozermapper.core.DozerBeanMapperBuilder;
import com.github.dozermapper.core.DozerConverter;
import com.github.dozermapper.core.Mapper;
import com.github.dozermapper.core.MapperAware;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeValueByteDozerConverter
extends DozerConverter<ByteBuffer, ByteBuffer>
implements MapperAware {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Mapper mapper = DozerBeanMapperBuilder.buildDefault();

    public AttributeValueByteDozerConverter() {
        super(ByteBuffer.class, ByteBuffer.class);
    }

    public ByteBuffer convertTo(ByteBuffer source, ByteBuffer destination) {
        if (source == null) {
            return ByteBuffer.wrap(new byte[0]);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(source.array().length);
        byteBuffer.put(source.array());
        return (ByteBuffer)byteBuffer.rewind();
    }

    public ByteBuffer convertFrom(ByteBuffer source, ByteBuffer destination) {
        if (source == null) {
            return ByteBuffer.wrap(new byte[0]);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(source.array().length);
        byteBuffer.put(source.array());
        return (ByteBuffer)byteBuffer.rewind();
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }
}

