/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.dynamodb.internal.service;

import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.DeleteTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexUpdate;
import com.amazonaws.services.dynamodbv2.model.ListTablesRequest;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.StreamSpecification;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateTableResult;
import java.util.Collection;
import java.util.List;
import org.mule.extension.dynamodb.api.model.GlobalSecondaryIndex;
import org.mule.extension.dynamodb.api.model.KeySchemaElement;
import org.mule.extension.dynamodb.api.model.LocalSecondaryIndex;
import org.mule.extension.dynamodb.api.model.StreamViewType;
import org.mule.extension.dynamodb.internal.config.DynamoDBConfiguration;
import org.mule.extension.dynamodb.internal.connection.DynamoDBConnection;
import org.mule.extension.dynamodb.internal.service.DynamoDBServiceImpl;
import org.mule.extension.dynamodb.internal.service.TableService;
import org.mule.extension.dynamodb.internal.util.DynamoDBModelFactory;

public class TableServiceImpl
extends DynamoDBServiceImpl
implements TableService {
    public TableServiceImpl(DynamoDBConfiguration config, DynamoDBConnection connection) {
        super(config, connection);
    }

    @Override
    public CreateTableResult create(String tableName, List<AttributeDefinition> attributeDefinitions, Collection<KeySchemaElement> keySchemas, Long readCapacityUnits, Long writeCapacityUnits, Collection<GlobalSecondaryIndex> globalSecondaryIndexes, Collection<LocalSecondaryIndex> localSecondaryIndexes, StreamViewType streamViewType, boolean streamEnabled) {
        return ((DynamoDBConnection)this.getConnection()).createTable(new CreateTableRequest().withTableName(tableName).withAttributeDefinitions(attributeDefinitions).withKeySchema(DynamoDBModelFactory.unwrapKeySchemaElementList(keySchemas)).withProvisionedThroughput(DynamoDBModelFactory.getProvisionedThroughput(readCapacityUnits, writeCapacityUnits)).withGlobalSecondaryIndexes(DynamoDBModelFactory.unwrapGlobalSecondaryIndexList(globalSecondaryIndexes)).withLocalSecondaryIndexes(DynamoDBModelFactory.unwrapLocalSecondaryIndexList(localSecondaryIndexes)).withStreamSpecification(DynamoDBModelFactory.unwrapgetStreamSpecication(streamViewType, streamEnabled)));
    }

    @Override
    public DeleteTableResult delete(String tableName) {
        return ((DynamoDBConnection)this.getConnection()).deleteTable(tableName);
    }

    @Override
    public DescribeTableResult describe(String tableName) {
        return ((DynamoDBConnection)this.getConnection()).describeTable(tableName);
    }

    @Override
    public ListTablesResult list(String exclusiveStartTableName, Integer limit) {
        ListTablesRequest listTablesRequest = new ListTablesRequest();
        if (exclusiveStartTableName != null || limit != null) {
            listTablesRequest.setExclusiveStartTableName(exclusiveStartTableName);
            listTablesRequest.setLimit(limit);
            return ((DynamoDBConnection)this.getConnection()).listTables(listTablesRequest);
        }
        return ((DynamoDBConnection)this.getConnection()).listTables();
    }

    @Override
    public UpdateTableResult update(String tableName, List<AttributeDefinition> sourceAttributeDefinitions, ProvisionedThroughput provisionedThroughput, List<GlobalSecondaryIndexUpdate> secondaryIndexUpdates, StreamSpecification streamSpecification) {
        return ((DynamoDBConnection)this.getConnection()).updateTable(new UpdateTableRequest().withTableName(tableName).withAttributeDefinitions(sourceAttributeDefinitions).withProvisionedThroughput(provisionedThroughput).withGlobalSecondaryIndexUpdates(secondaryIndexUpdates).withStreamSpecification(streamSpecification));
    }
}

