/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.dynamodb.internal.service;

import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import java.util.Map;
import java.util.Optional;
import org.mule.extension.dynamodb.api.model.Condition;
import org.mule.extension.dynamodb.api.model.Select;
import org.mule.extension.dynamodb.internal.config.DynamoDBConfiguration;
import org.mule.extension.dynamodb.internal.connection.DynamoDBConnection;
import org.mule.extension.dynamodb.internal.operation.param.QueryParameters;
import org.mule.extension.dynamodb.internal.service.DynamoDBServiceImpl;
import org.mule.extension.dynamodb.internal.service.QueryService;
import org.mule.extension.dynamodb.internal.util.DynamoDBModelFactory;

public class QueryServiceImpl
extends DynamoDBServiceImpl
implements QueryService {
    public QueryServiceImpl(DynamoDBConfiguration config, DynamoDBConnection connection) {
        super(config, connection);
    }

    @Override
    public QueryResult query(QueryParameters queryParameters, String keyConditionExpression, Map<String, Condition> keyConditions, boolean scanIndexForward, Select select) {
        QueryRequest queryRequest = new QueryRequest();
        queryRequest.setTableName(queryParameters.getTableName());
        queryRequest.setAttributesToGet(queryParameters.getAttributesToGets());
        Optional.ofNullable(queryRequest.getConditionalOperator()).map(Object::toString).ifPresent(arg_0 -> ((QueryRequest)queryRequest).setConditionalOperator(arg_0));
        queryRequest.setConsistentRead(queryRequest.isConsistentRead());
        queryRequest.setExclusiveStartKey(DynamoDBModelFactory.unwrapKey(queryParameters.getExclusiveStartKey()));
        queryRequest.setExpressionAttributeNames(queryParameters.getAttributeNames());
        queryRequest.setExpressionAttributeValues(DynamoDBModelFactory.unwrapKey(queryParameters.getAttributeValues()));
        queryRequest.setFilterExpression(queryParameters.getFilterExpression());
        queryRequest.setIndexName(queryParameters.getIndexName());
        queryRequest.setKeyConditionExpression(keyConditionExpression);
        queryRequest.setKeyConditions(DynamoDBModelFactory.unwrapKeyConditionsorFilters(keyConditions));
        queryRequest.setQueryFilter(DynamoDBModelFactory.unwrapKeyConditionsorFilters(queryParameters.getConditionFilter()));
        queryRequest.setLimit(queryParameters.getLimit());
        queryRequest.setProjectionExpression(queryParameters.getProjectionExpression());
        Optional.ofNullable(queryRequest.getReturnConsumedCapacity()).map(Object::toString).ifPresent(arg_0 -> ((QueryRequest)queryRequest).setReturnConsumedCapacity(arg_0));
        queryRequest.setScanIndexForward(Boolean.valueOf(scanIndexForward));
        if (select != null) {
            queryRequest.setSelect(select.toString());
        }
        return ((DynamoDBConnection)this.getConnection()).query(queryRequest);
    }

    @Override
    public ScanResult scan(QueryParameters queryParameters, Integer segment, Select select, Integer totalSegments) {
        ScanRequest scanRequest = new ScanRequest();
        scanRequest.setTableName(queryParameters.getTableName());
        scanRequest.setAttributesToGet(queryParameters.getAttributesToGets());
        Optional.ofNullable(queryParameters.getConditionalOperator()).map(Object::toString).ifPresent(arg_0 -> ((ScanRequest)scanRequest).setConditionalOperator(arg_0));
        scanRequest.setConsistentRead(Boolean.valueOf(queryParameters.isConsistentRead()));
        scanRequest.setExclusiveStartKey(DynamoDBModelFactory.unwrapKey(queryParameters.getExclusiveStartKey()));
        scanRequest.setExpressionAttributeNames(queryParameters.getAttributeNames());
        scanRequest.setExpressionAttributeValues(DynamoDBModelFactory.unwrapKey(queryParameters.getAttributeValues()));
        scanRequest.setFilterExpression(queryParameters.getFilterExpression());
        scanRequest.setIndexName(queryParameters.getIndexName());
        scanRequest.setLimit(queryParameters.getLimit());
        scanRequest.setProjectionExpression(queryParameters.getProjectionExpression());
        Optional.ofNullable(queryParameters.getReturnConsumedCapacity()).map(Object::toString).ifPresent(arg_0 -> ((ScanRequest)scanRequest).setReturnConsumedCapacity(arg_0));
        scanRequest.setScanFilter(DynamoDBModelFactory.unwrapKeyConditionsorFilters(queryParameters.getConditionFilter()));
        scanRequest.setSegment(segment);
        if (select != null) {
            scanRequest.setSelect(select.toString());
        }
        scanRequest.setTotalSegments(totalSegments);
        return ((DynamoDBConnection)this.getConnection()).scan(scanRequest);
    }
}

