/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.dynamodb.internal.service;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.amazonaws.services.dynamodbv2.model.ExpectedAttributeValue;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.extension.dynamodb.api.model.ReturnConsumedCapacity;
import org.mule.extension.dynamodb.api.model.ReturnItemCollectionMetrics;
import org.mule.extension.dynamodb.api.model.ReturnValue;
import org.mule.extension.dynamodb.internal.config.DynamoDBConfiguration;
import org.mule.extension.dynamodb.internal.connection.DynamoDBConnection;
import org.mule.extension.dynamodb.internal.operation.param.Condition;
import org.mule.extension.dynamodb.internal.operation.param.Expression;
import org.mule.extension.dynamodb.internal.service.DynamoDBServiceImpl;
import org.mule.extension.dynamodb.internal.service.ItemService;
import org.mule.extension.dynamodb.internal.util.DynamoDBModelFactory;

public class ItemServiceImpl
extends DynamoDBServiceImpl
implements ItemService {
    public ItemServiceImpl(DynamoDBConfiguration config, DynamoDBConnection connection) {
        super(config, connection);
    }

    @Override
    public UpdateItemResult update(String tableName, Map<String, AttributeValue> key, Condition condition, Expression expression, ReturnConsumedCapacity returnConsumedCapacity, ReturnItemCollectionMetrics returnItemCollectionMetrics, ReturnValue returnValues, String updateExpression, Map<String, AttributeValueUpdate> attributeUpdates, Map<String, ExpectedAttributeValue> expected) {
        UpdateItemRequest updateItemRequest = new UpdateItemRequest();
        updateItemRequest.setTableName(tableName);
        updateItemRequest.setKey(key);
        updateItemRequest.setConditionExpression(condition.getConditionExpression());
        updateItemRequest.setExpressionAttributeNames(expression.getAttributeNames());
        updateItemRequest.setExpressionAttributeValues(DynamoDBModelFactory.unwrapKey(expression.getAttributeValues()));
        updateItemRequest.setUpdateExpression(updateExpression);
        updateItemRequest.setExpected(expected);
        updateItemRequest.setAttributeUpdates(attributeUpdates);
        Optional.ofNullable(condition.getConditionalOperator()).map(Object::toString).ifPresent(arg_0 -> ((UpdateItemRequest)updateItemRequest).setConditionalOperator(arg_0));
        if (returnItemCollectionMetrics != null) {
            updateItemRequest.setReturnItemCollectionMetrics(returnItemCollectionMetrics.toString());
        }
        if (returnValues != null) {
            updateItemRequest.setReturnValues(returnValues.toString());
        }
        if (returnConsumedCapacity != null) {
            updateItemRequest.setReturnConsumedCapacity(returnConsumedCapacity.toString());
        }
        return ((DynamoDBConnection)this.getConnection()).updateItem(updateItemRequest);
    }

    @Override
    public GetItemResult get(String tableName, Map<String, AttributeValue> key, List<String> attributesToGet, boolean consistentRead, Map<String, String> expressionAttributeNames, String projectionExpression, String returnConsumedCapacity) {
        return ((DynamoDBConnection)this.getConnection()).getItem(new GetItemRequest().withTableName(tableName).withConsistentRead(Boolean.valueOf(consistentRead)).withReturnConsumedCapacity(returnConsumedCapacity).withProjectionExpression(projectionExpression).withExpressionAttributeNames(expressionAttributeNames).withAttributesToGet(attributesToGet).withKey(key));
    }

    @Override
    public PutItemResult add(String tableName, Map<String, AttributeValue> item) {
        return ((DynamoDBConnection)this.getConnection()).putItem(new PutItemRequest().withReturnValues("ALL_OLD").withTableName(tableName).withItem(item));
    }

    @Override
    public DeleteItemResult delete(String tableName, Map<String, AttributeValue> primarykey) {
        return ((DynamoDBConnection)this.getConnection()).deleteItem(new DeleteItemRequest().withReturnValues("ALL_OLD").withTableName(tableName).withKey(primarykey));
    }
}

