/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.dynamodb.internal.service;

import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.ReturnConsumedCapacity;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import java.util.List;
import java.util.Map;
import org.mule.extension.dynamodb.api.model.KeysAndAttributes;
import org.mule.extension.dynamodb.internal.config.DynamoDBConfiguration;
import org.mule.extension.dynamodb.internal.connection.DynamoDBConnection;
import org.mule.extension.dynamodb.internal.service.DynamoDBServiceImpl;
import org.mule.extension.dynamodb.internal.service.ItemBatchService;
import org.mule.extension.dynamodb.internal.util.DynamoDBModelFactory;

public class ItemBatchServiceImpl
extends DynamoDBServiceImpl
implements ItemBatchService {
    public ItemBatchServiceImpl(DynamoDBConfiguration config, DynamoDBConnection connection) {
        super(config, connection);
    }

    @Override
    public BatchWriteItemResult add(Map<String, List<WriteRequest>> requestPutItems) {
        return ((DynamoDBConnection)this.getConnection()).batchWriteItem(new BatchWriteItemRequest().withRequestItems(requestPutItems).withReturnConsumedCapacity(ReturnConsumedCapacity.TOTAL));
    }

    @Override
    public BatchWriteItemResult delete(Map<String, List<WriteRequest>> requestDeleteItems) {
        return ((DynamoDBConnection)this.getConnection()).batchWriteItem(new BatchWriteItemRequest().withRequestItems(requestDeleteItems).withReturnConsumedCapacity(ReturnConsumedCapacity.TOTAL));
    }

    @Override
    public BatchGetItemResult get(Map<String, KeysAndAttributes> requestItems, org.mule.extension.dynamodb.api.model.ReturnConsumedCapacity returnConsumedCapacity) {
        BatchGetItemRequest batchGetItemRequest = new BatchGetItemRequest();
        batchGetItemRequest.setRequestItems(DynamoDBModelFactory.unwrapRequestItems(requestItems));
        if (returnConsumedCapacity != null) {
            batchGetItemRequest.setReturnConsumedCapacity(returnConsumedCapacity.toString());
        }
        return ((DynamoDBConnection)this.getConnection()).batchGetItem(batchGetItemRequest);
    }
}

