/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.dynamodb.internal.operation.paging;

import java.util.Map;
import org.mule.extension.dynamodb.api.model.Condition;
import org.mule.extension.dynamodb.api.model.Select;
import org.mule.extension.dynamodb.internal.config.DynamoDBConfiguration;
import org.mule.extension.dynamodb.internal.operation.paging.QueryPagingProvider;
import org.mule.extension.dynamodb.internal.operation.param.QueryParameters;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

public class QueryPagingProviderBuilder {
    private DynamoDBConfiguration config;
    private QueryParameters queryParameters;
    private String keyConditionExpression;
    private Map<String, Condition> keyConditions;
    private boolean scanIndexForward;
    private Select select;
    private StreamingHelper streamingHelper;

    public QueryPagingProviderBuilder withConfig(DynamoDBConfiguration config) {
        this.config = config;
        return this;
    }

    public QueryPagingProviderBuilder withQueryParameters(QueryParameters queryParameters) {
        this.queryParameters = queryParameters;
        return this;
    }

    public QueryPagingProviderBuilder withKeyConditionExpression(String keyConditionExpression) {
        this.keyConditionExpression = keyConditionExpression;
        return this;
    }

    public QueryPagingProviderBuilder withKeyConditions(Map<String, Condition> keyConditions) {
        this.keyConditions = keyConditions;
        return this;
    }

    public QueryPagingProviderBuilder withScanIndexForward(boolean scanIndexForward) {
        this.scanIndexForward = scanIndexForward;
        return this;
    }

    public QueryPagingProviderBuilder withSelect(Select select) {
        this.select = select;
        return this;
    }

    public QueryPagingProviderBuilder withStreamingHelper(StreamingHelper streamingHelper) {
        this.streamingHelper = streamingHelper;
        return this;
    }

    public QueryPagingProvider build() {
        return new QueryPagingProvider(this.config, this.queryParameters, this.keyConditionExpression, this.keyConditions, this.scanIndexForward, this.select, this.streamingHelper);
    }
}

