/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.dynamodb.internal.operation.paging;

import com.amazonaws.services.dynamodbv2.model.QueryResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.mule.extension.dynamodb.api.attributes.RequestIDAttribute;
import org.mule.extension.dynamodb.api.model.AttributeValue;
import org.mule.extension.dynamodb.api.model.Condition;
import org.mule.extension.dynamodb.api.model.Select;
import org.mule.extension.dynamodb.internal.config.DynamoDBConfiguration;
import org.mule.extension.dynamodb.internal.connection.DynamoDBConnection;
import org.mule.extension.dynamodb.internal.operation.param.QueryParameters;
import org.mule.extension.dynamodb.internal.service.QueryServiceImpl;
import org.mule.extension.dynamodb.internal.util.DynamoDBModelFactory;
import org.mule.extension.dynamodb.internal.util.MapUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryPagingProvider
implements PagingProvider<DynamoDBConnection, Result<List<Map<String, AttributeValue>>, RequestIDAttribute>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryPagingProvider.class);
    private final DynamoDBConfiguration config;
    private final QueryParameters queryParameters;
    private final String keyConditionExpression;
    private final Map<String, Condition> keyConditions;
    private final boolean scanIndexForward;
    private final Select select;
    private final StreamingHelper streamingHelper;
    private QueryResult queryResult;

    protected QueryPagingProvider(DynamoDBConfiguration config, QueryParameters queryParameters, String keyConditionExpression, Map<String, Condition> keyConditions, boolean scanIndexForward, Select select, StreamingHelper streamingHelper) {
        this.config = config;
        this.queryParameters = queryParameters;
        this.streamingHelper = streamingHelper;
        this.keyConditionExpression = keyConditionExpression;
        this.keyConditions = keyConditions;
        this.scanIndexForward = scanIndexForward;
        this.select = select;
    }

    public List<Result<List<Map<String, AttributeValue>>, RequestIDAttribute>> getPage(DynamoDBConnection connection) {
        QueryServiceImpl service = new QueryServiceImpl(this.config, connection);
        ArrayList<Result<List<Map<String, AttributeValue>>, RequestIDAttribute>> page = new ArrayList<Result<List<Map<String, AttributeValue>>, RequestIDAttribute>>();
        if (!Objects.isNull(this.queryResult) && Objects.isNull(this.queryResult.getLastEvaluatedKey())) {
            LOGGER.debug("No more results found. Finishing the pagination...");
            return page;
        }
        if (!Objects.isNull(this.queryResult) && !Objects.isNull(this.queryResult.getLastEvaluatedKey())) {
            Map<String, AttributeValue> lastEvaluatedKey = DynamoDBModelFactory.wrapStringAttributeValueMap(this.queryResult.getLastEvaluatedKey());
            LOGGER.info("Retrieving more results from Last Evaluated Key: {}", (Object)MapUtils.toString(lastEvaluatedKey));
            this.queryParameters.setExclusiveStartKey(lastEvaluatedKey);
        }
        this.queryResult = service.query(this.queryParameters, this.keyConditionExpression, this.keyConditions, this.scanIndexForward, this.select);
        page.add((Result<List<Map<String, AttributeValue>>, RequestIDAttribute>)((Result)this.streamingHelper.resolveCursorProvider(DynamoDBModelFactory.wrapPaginatedResult(this.queryResult))));
        return page;
    }

    public Optional<Integer> getTotalResults(DynamoDBConnection dynamoDBStreamsConnection) {
        return Optional.empty();
    }

    public void close(DynamoDBConnection dynamoDBStreamsConnection) throws MuleException {
    }

    public boolean useStickyConnections() {
        return true;
    }
}

