/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.dynamodb.internal.operation.paging;

import com.amazonaws.AmazonWebServiceResult;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.extension.dynamodb.api.attributes.RequestIDAttribute;
import org.mule.extension.dynamodb.internal.connection.DynamoDBStreamsConnection;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;

public abstract class DynamoDBStreamsPagingProvider<TYPE, UNPARSED_TYPE, REQUEST, RESULT extends AmazonWebServiceResult>
implements PagingProvider<DynamoDBStreamsConnection, Result<TYPE, RequestIDAttribute>> {
    private final BiFunction<DynamoDBStreamsConnection, REQUEST, RESULT> clientListFunction;
    private final BiFunction<REQUEST, String, REQUEST> appendNextTokenFunction;
    private final Supplier<RESULT> resultConstructor;
    private final Function<RESULT, List<UNPARSED_TYPE>> extractionFunction;
    private final Function<UNPARSED_TYPE, TYPE> parsingFunction;
    private final REQUEST request;
    private final Function<RESULT, String> getNextTokenFunction;
    private Function<DynamoDBStreamsConnection, RESULT> resultRetrievalFunction;

    public DynamoDBStreamsPagingProvider(REQUEST request, BiFunction<DynamoDBStreamsConnection, REQUEST, RESULT> clientListFunction, Function<RESULT, String> getNextTokenFunction, BiFunction<REQUEST, String, REQUEST> appendNextTokenFunction, Supplier<RESULT> resultConstructor, Function<RESULT, List<UNPARSED_TYPE>> extractionFunction, Function<UNPARSED_TYPE, TYPE> parsingFunction) {
        this.request = request;
        this.resultRetrievalFunction = client -> (AmazonWebServiceResult)clientListFunction.apply((DynamoDBStreamsConnection)((Object)client), request);
        this.clientListFunction = clientListFunction;
        this.getNextTokenFunction = getNextTokenFunction;
        this.appendNextTokenFunction = appendNextTokenFunction;
        this.resultConstructor = resultConstructor;
        this.extractionFunction = extractionFunction;
        this.parsingFunction = parsingFunction;
    }

    public List<Result<TYPE, RequestIDAttribute>> getPage(DynamoDBStreamsConnection streamsClient) {
        AmazonWebServiceResult result = (AmazonWebServiceResult)this.resultRetrievalFunction.apply(streamsClient);
        this.resultRetrievalFunction = Optional.ofNullable(this.getNextTokenFunction.apply(result)).map(token -> client -> (AmazonWebServiceResult)this.clientListFunction.apply((DynamoDBStreamsConnection)((Object)((Object)client)), this.appendNextTokenFunction.apply(this.request, (String)token))).orElseGet(() -> value -> (AmazonWebServiceResult)this.resultConstructor.get());
        return this.extractionFunction.apply(result).stream().map(this.parsingFunction).map(parsedValue -> Result.builder().output(parsedValue).attributes((Object)new RequestIDAttribute(result.getSdkResponseMetadata().getRequestId())).mediaType(MediaType.APPLICATION_JAVA).build()).collect(Collectors.toList());
    }

    public Optional<Integer> getTotalResults(DynamoDBStreamsConnection streamsClient) {
        return Optional.empty();
    }

    public void close(DynamoDBStreamsConnection streamsClient) {
    }
}

