/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.dynamodb.internal.operation;

import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.github.dozermapper.core.Mapper;
import java.util.List;
import org.mule.connectors.atlantic.commons.builder.execution.HeptaParamExecutionBuilder;
import org.mule.connectors.atlantic.commons.builder.execution.MonoParamExecutionBuilder;
import org.mule.connectors.atlantic.commons.builder.execution.TriParamExecutionBuilder;
import org.mule.extension.dynamodb.api.attributes.RequestIDAttribute;
import org.mule.extension.dynamodb.api.model.AttributeDefinition;
import org.mule.extension.dynamodb.api.model.GlobalSecondaryIndex;
import org.mule.extension.dynamodb.api.model.GlobalSecondaryIndexUpdate;
import org.mule.extension.dynamodb.api.model.KeySchemaElement;
import org.mule.extension.dynamodb.api.model.ListTablesResult;
import org.mule.extension.dynamodb.api.model.LocalSecondaryIndex;
import org.mule.extension.dynamodb.api.model.StreamViewType;
import org.mule.extension.dynamodb.api.model.TableDescription;
import org.mule.extension.dynamodb.internal.config.DynamoDBConfiguration;
import org.mule.extension.dynamodb.internal.connection.DynamoDBConnection;
import org.mule.extension.dynamodb.internal.error.provider.DynamoDBErrorTypeProvider;
import org.mule.extension.dynamodb.internal.metadata.provider.TableValueProvider;
import org.mule.extension.dynamodb.internal.operation.DynamoDBOperations;
import org.mule.extension.dynamodb.internal.operation.unwrapper.ListUnwrapper;
import org.mule.extension.dynamodb.internal.service.TableService;
import org.mule.extension.dynamodb.internal.service.TableServiceImpl;
import org.mule.extension.dynamodb.internal.util.DozerBeanMapperSingletonWrapper;
import org.mule.extension.dynamodb.internal.util.DynamoDBModelFactory;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.runtime.extension.api.runtime.operation.Result;

@Throws(value={DynamoDBErrorTypeProvider.class})
public class TableOperations
extends DynamoDBOperations<TableService> {
    private Mapper mapper = DozerBeanMapperSingletonWrapper.getInstance();

    public TableOperations() {
        super(TableServiceImpl::new);
    }

    public Result<TableDescription, RequestIDAttribute> createTable(@Config DynamoDBConfiguration config, @Connection DynamoDBConnection connection, String tableName, List<AttributeDefinition> attributeDefinitions, List<KeySchemaElement> keySchemas, @Summary(value="The maximum number of strongly consistent reads consumed per second.") Long readCapacityUnits, @Summary(value="The maximum number of writes consumed per second.") Long writeCapacityUnits, @Optional List<GlobalSecondaryIndex> globalSecondaryIndexes, @Optional List<LocalSecondaryIndex> localSecondaryIndexes, @Summary(value="StreamViewType determines what information is written to the table's stream.") @Optional StreamViewType streamViewType, @Optional boolean streamEnabled) {
        return (Result)((HeptaParamExecutionBuilder)this.newExecutionBuilder(config, connection).execute(TableService::create, DynamoDBModelFactory::wrapCreateTable).withParam((Object)tableName).withParam(attributeDefinitions, new ListUnwrapper(this.mapper, com.amazonaws.services.dynamodbv2.model.AttributeDefinition.class))).withParam(keySchemas).withParam((Object)readCapacityUnits).withParam((Object)writeCapacityUnits).withParam(globalSecondaryIndexes).withParam(localSecondaryIndexes).withParam((Object)streamViewType).withParam((Object)streamEnabled);
    }

    public Result<TableDescription, RequestIDAttribute> deleteTable(@Config DynamoDBConfiguration config, @Connection DynamoDBConnection connection, @OfValues(value=TableValueProvider.class) String tableName) {
        return (Result)this.newExecutionBuilder(config, connection).execute(TableService::delete, DynamoDBModelFactory::wrapDeleteTable).withParam((Object)tableName);
    }

    public Result<TableDescription, RequestIDAttribute> describeTable(@Config DynamoDBConfiguration config, @Connection DynamoDBConnection connection, @OfValues(value=TableValueProvider.class) String tableName) {
        return (Result)this.newExecutionBuilder(config, connection).execute(TableService::describe, DynamoDBModelFactory::wrapDescribeTable).withParam((Object)tableName);
    }

    public Result<ListTablesResult, RequestIDAttribute> listTables(@Config DynamoDBConfiguration config, @Connection DynamoDBConnection connection, @Summary(value="The first table name that this operation will evaluate.") @Optional String exclusiveStartTableName, @Optional Integer limit) {
        return (Result)this.newExecutionBuilder(config, connection).execute(TableService::list, DynamoDBModelFactory::wrap).withParam((Object)exclusiveStartTableName).withParam((Object)limit);
    }

    public Result<TableDescription, RequestIDAttribute> updateTable(@Config DynamoDBConfiguration config, @Connection DynamoDBConnection connection, @OfValues(value=TableValueProvider.class) String tableName, @Summary(value="An array of attributes that describe the key schema") @Optional List<AttributeDefinition> attributeDefinitions, @Summary(value="The maximum number of strongly consistent reads") @Optional Long readCapacityUnits, @Summary(value="The maximum number of writes consumed per second") @Optional Long writeCapacityUnits, @Optional List<GlobalSecondaryIndexUpdate> globalSecondaryIndexUpdates, @Summary(value="StreamViewType determines what information is written to the stream for this table.") @Optional StreamViewType streamViewType, @Optional boolean streamEnabled) {
        return (Result)((MonoParamExecutionBuilder)((TriParamExecutionBuilder)this.newExecutionBuilder(config, connection).execute(TableService::update, DynamoDBModelFactory::wrapUpdateTable).withParam((Object)tableName).withParam(attributeDefinitions, new ListUnwrapper(this.mapper, com.amazonaws.services.dynamodbv2.model.AttributeDefinition.class))).withParam((Object)new ProvisionedThroughput(readCapacityUnits, writeCapacityUnits)).withParam(globalSecondaryIndexUpdates, DynamoDBModelFactory::unwrapGlobalSecondaryIndexUpdates)).withParam((Object)streamViewType, viewType -> DynamoDBModelFactory.unwrapgetStreamSpecication(viewType, streamEnabled));
    }
}

