/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.dynamodb.internal.operation;

import java.util.List;
import java.util.Map;
import org.mule.extension.dynamodb.api.attributes.RequestIDAttribute;
import org.mule.extension.dynamodb.api.model.AttributeValue;
import org.mule.extension.dynamodb.api.model.Condition;
import org.mule.extension.dynamodb.api.model.QueryResult;
import org.mule.extension.dynamodb.api.model.ScanResult;
import org.mule.extension.dynamodb.api.model.Select;
import org.mule.extension.dynamodb.internal.config.DynamoDBConfiguration;
import org.mule.extension.dynamodb.internal.connection.DynamoDBConnection;
import org.mule.extension.dynamodb.internal.error.provider.DynamoDBErrorTypeProvider;
import org.mule.extension.dynamodb.internal.operation.DynamoDBOperations;
import org.mule.extension.dynamodb.internal.operation.paging.QueryPagingProviderBuilder;
import org.mule.extension.dynamodb.internal.operation.param.QueryParameters;
import org.mule.extension.dynamodb.internal.service.QueryService;
import org.mule.extension.dynamodb.internal.service.QueryServiceImpl;
import org.mule.extension.dynamodb.internal.util.DynamoDBModelFactory;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;

@Throws(value={DynamoDBErrorTypeProvider.class})
public class QueryOperations
extends DynamoDBOperations<QueryService> {
    public QueryOperations() {
        super(QueryServiceImpl::new);
    }

    public Result<QueryResult, RequestIDAttribute> query(@Config DynamoDBConfiguration config, @Connection DynamoDBConnection connection, @ParameterGroup(name="Query Parameters") QueryParameters queryParameters, @Optional String keyConditionExpression, @Summary(value="The condition that specifies the key values for items.") @Optional Map<String, Condition> keyConditions, @Summary(value="Specifies the order for index traversal.") @Optional boolean scanIndexForward, @Optional Select select) {
        return (Result)this.newExecutionBuilder(config, connection).execute(QueryService::query, DynamoDBModelFactory::wrap).withParam((Object)queryParameters).withParam((Object)keyConditionExpression).withParam(keyConditions).withParam((Object)scanIndexForward).withParam((Object)select);
    }

    public PagingProvider<DynamoDBConnection, Result<List<Map<String, AttributeValue>>, RequestIDAttribute>> paginatedQuery(@Config DynamoDBConfiguration config, @ParameterGroup(name="Query Parameters") QueryParameters queryParameters, @Optional String keyConditionExpression, @Summary(value="The condition that specifies the key values for items.") @Optional Map<String, Condition> keyConditions, @Summary(value="Specifies the order for index traversal.") @Optional boolean scanIndexForward, @Optional Select select, StreamingHelper streamingHelper) {
        return new QueryPagingProviderBuilder().withConfig(config).withQueryParameters(queryParameters).withKeyConditionExpression(keyConditionExpression).withKeyConditions(keyConditions).withScanIndexForward(scanIndexForward).withSelect(select).withStreamingHelper(streamingHelper).build();
    }

    public Result<ScanResult, RequestIDAttribute> scan(@Config DynamoDBConfiguration config, @Connection DynamoDBConnection connection, @ParameterGroup(name="Query Parameters") QueryParameters queryParameters, @Summary(value="Segment identifies an individual segment to be scanned by an application worker.") @Optional Integer segment, @Optional Select select, @Summary(value="TotalSegments represents the total number of segments") @Optional Integer totalSegments) {
        return (Result)this.newExecutionBuilder(config, connection).execute(QueryService::scan, DynamoDBModelFactory::wrap).withParam((Object)queryParameters).withParam((Object)segment).withParam((Object)select).withParam((Object)totalSegments);
    }
}

