/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.dynamodb.internal.operation;

import java.util.List;
import java.util.Map;
import org.mule.connectors.atlantic.commons.builder.execution.MonoParamExecutionBuilder;
import org.mule.connectors.atlantic.commons.builder.execution.OctaParamExecutionBuilder;
import org.mule.connectors.atlantic.commons.builder.execution.PentaParamExecutionBuilder;
import org.mule.extension.dynamodb.api.attributes.RequestIDAttribute;
import org.mule.extension.dynamodb.api.model.AttributeValue;
import org.mule.extension.dynamodb.api.model.AttributeValueUpdate;
import org.mule.extension.dynamodb.api.model.DeleteItemResult;
import org.mule.extension.dynamodb.api.model.ExpectedAttributeValue;
import org.mule.extension.dynamodb.api.model.GetItemResult;
import org.mule.extension.dynamodb.api.model.PutItemResult;
import org.mule.extension.dynamodb.api.model.ReturnConsumedCapacity;
import org.mule.extension.dynamodb.api.model.ReturnItemCollectionMetrics;
import org.mule.extension.dynamodb.api.model.ReturnValue;
import org.mule.extension.dynamodb.api.model.UpdateItemResult;
import org.mule.extension.dynamodb.internal.config.DynamoDBConfiguration;
import org.mule.extension.dynamodb.internal.connection.DynamoDBConnection;
import org.mule.extension.dynamodb.internal.error.provider.DynamoDBErrorTypeProvider;
import org.mule.extension.dynamodb.internal.metadata.KeyInputMetadataResolver;
import org.mule.extension.dynamodb.internal.metadata.KeyMetadataResolver;
import org.mule.extension.dynamodb.internal.operation.DynamoDBOperations;
import org.mule.extension.dynamodb.internal.operation.param.Condition;
import org.mule.extension.dynamodb.internal.operation.param.Expression;
import org.mule.extension.dynamodb.internal.service.ItemService;
import org.mule.extension.dynamodb.internal.service.ItemServiceImpl;
import org.mule.extension.dynamodb.internal.util.DynamoDBModelFactory;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.TypeResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;

@Throws(value={DynamoDBErrorTypeProvider.class})
public class ItemOperations
extends DynamoDBOperations<ItemService> {
    public ItemOperations() {
        super(ItemServiceImpl::new);
    }

    public Result<GetItemResult, RequestIDAttribute> getItem(@Config DynamoDBConfiguration config, @Connection DynamoDBConnection connection, @MetadataKeyId(value=KeyMetadataResolver.class) String tableName, @Summary(value="A map of attribute names to AttributeValue objects") @TypeResolver(value=KeyInputMetadataResolver.class) @Content Map<String, AttributeValue> key, @Optional List<String> attributesToGets, @Summary(value="Determines the read consistency model") @Optional boolean consistentRead, @Summary(value="One or more substitution tokens for attribute names in an expression.") @Optional Map<String, String> expressionAttributeNames, @Optional String projectionExpression, @Optional(defaultValue="NONE") ReturnConsumedCapacity returnConsumedCapacity) {
        return (Result)((PentaParamExecutionBuilder)this.newExecutionBuilder(config, connection).execute(ItemService::get, DynamoDBModelFactory::wrap).withParam((Object)tableName).withParam(key, DynamoDBModelFactory::unwrapKey)).withParam(attributesToGets).withParam((Object)consistentRead).withParam(expressionAttributeNames).withParam((Object)projectionExpression).withParam((Object)returnConsumedCapacity, Enum::name);
    }

    public Result<PutItemResult, RequestIDAttribute> putItem(@Config DynamoDBConfiguration config, @Connection DynamoDBConnection connection, @MetadataKeyId(value=KeyMetadataResolver.class) String tableName, @TypeResolver(value=KeyInputMetadataResolver.class) @Content Map<String, AttributeValue> item) {
        return (Result)this.newExecutionBuilder(config, connection).execute(ItemService::add, DynamoDBModelFactory::wrap).withParam((Object)tableName).withParam(item, DynamoDBModelFactory::unwrapKey);
    }

    public Result<DeleteItemResult, RequestIDAttribute> deleteItem(@Config DynamoDBConfiguration config, @Connection DynamoDBConnection connection, @MetadataKeyId(value=KeyMetadataResolver.class) String tableName, @TypeResolver(value=KeyInputMetadataResolver.class) @Content Map<String, AttributeValue> primarykey) {
        return (Result)this.newExecutionBuilder(config, connection).execute(ItemService::delete, DynamoDBModelFactory::wrap).withParam((Object)tableName).withParam(primarykey, DynamoDBModelFactory::unwrapKey);
    }

    public Result<UpdateItemResult, RequestIDAttribute> updateItem(@Config DynamoDBConfiguration config, @Connection DynamoDBConnection connection, @MetadataKeyId(value=KeyMetadataResolver.class) String tableName, @TypeResolver(value=KeyInputMetadataResolver.class) @Content Map<String, AttributeValue> key, @ParameterGroup(name="Condition") Condition condition, @ParameterGroup(name="Expression") Expression expression, @Summary(value="Determines the level of detail about provisioned consumption.") @Optional ReturnConsumedCapacity returnConsumedCapacity, @Optional ReturnItemCollectionMetrics returnItemCollectionMetrics, @Summary(value="Use if you want to get the item attributes as they appear.") @Optional ReturnValue returnValues, @Summary(value="An expression that defines one or more attributes to be updated.") @Optional String updateExpression, @Optional Map<String, AttributeValueUpdate> attributeUpdates, @Optional Map<String, ExpectedAttributeValue> expected) {
        return (Result)((MonoParamExecutionBuilder)((OctaParamExecutionBuilder)this.newExecutionBuilder(config, connection).execute(ItemService::update, DynamoDBModelFactory::updateItem).withParam((Object)tableName).withParam(key, DynamoDBModelFactory::unwrapKey)).withParam((Object)condition).withParam((Object)expression).withParam((Object)returnConsumedCapacity).withParam((Object)returnItemCollectionMetrics).withParam((Object)returnValues).withParam((Object)updateExpression).withParam(attributeUpdates, DynamoDBModelFactory::unwrapAttributeValueUpdate)).withParam(expected, DynamoDBModelFactory::unwrapExpected);
    }
}

