/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.dynamodb.internal.operation;

import java.util.List;
import java.util.Map;
import org.mule.extension.dynamodb.api.attributes.RequestIDAttribute;
import org.mule.extension.dynamodb.api.model.BatchGetItemResult;
import org.mule.extension.dynamodb.api.model.BatchWriteItemResult;
import org.mule.extension.dynamodb.api.model.KeysAndAttributes;
import org.mule.extension.dynamodb.api.model.ReturnConsumedCapacity;
import org.mule.extension.dynamodb.api.model.WriteRequest;
import org.mule.extension.dynamodb.internal.config.DynamoDBConfiguration;
import org.mule.extension.dynamodb.internal.connection.DynamoDBConnection;
import org.mule.extension.dynamodb.internal.error.provider.DynamoDBErrorTypeProvider;
import org.mule.extension.dynamodb.internal.operation.DynamoDBOperations;
import org.mule.extension.dynamodb.internal.service.ItemBatchService;
import org.mule.extension.dynamodb.internal.service.ItemBatchServiceImpl;
import org.mule.extension.dynamodb.internal.util.DynamoDBModelFactory;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;

@Throws(value={DynamoDBErrorTypeProvider.class})
public class ItemBatchOperations
extends DynamoDBOperations<ItemBatchService> {
    public ItemBatchOperations() {
        super(ItemBatchServiceImpl::new);
    }

    public Result<BatchWriteItemResult, RequestIDAttribute> batchPutItem(@Config DynamoDBConfiguration config, @Connection DynamoDBConnection connection, Map<String, List<WriteRequest>> requestPutItems) {
        return (Result)this.newExecutionBuilder(config, connection).execute(ItemBatchService::add, DynamoDBModelFactory::wrap).withParam(requestPutItems, DynamoDBModelFactory::unwrapRequestPutItem);
    }

    public Result<BatchWriteItemResult, RequestIDAttribute> batchDeleteItem(@Config DynamoDBConfiguration config, @Connection DynamoDBConnection connection, Map<String, List<WriteRequest>> requestDeleteItems) {
        return (Result)this.newExecutionBuilder(config, connection).execute(ItemBatchService::delete, DynamoDBModelFactory::wrap).withParam(requestDeleteItems, DynamoDBModelFactory::unwrapRequestPutItem);
    }

    public Result<BatchGetItemResult, RequestIDAttribute> batchGetItem(@Config DynamoDBConfiguration config, @Connection DynamoDBConnection connection, @Summary(value="A map of one or more table names") Map<String, KeysAndAttributes> requestItems, @Summary(value="Determines the level of detail about provisioned consumption") @Optional ReturnConsumedCapacity returnConsumedCapacity) {
        return (Result)this.newExecutionBuilder(config, connection).execute(ItemBatchService::get, DynamoDBModelFactory::wrap).withParam(requestItems).withParam((Object)returnConsumedCapacity);
    }
}

