/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.dynamodb.internal.operation;

import com.amazonaws.services.dynamodbv2.model.DescribeStreamRequest;
import com.amazonaws.services.dynamodbv2.model.GetRecordsRequest;
import com.amazonaws.services.dynamodbv2.model.GetShardIteratorRequest;
import com.amazonaws.services.dynamodbv2.model.ListStreamsRequest;
import org.mule.extension.dynamodb.api.attributes.RequestIDAttribute;
import org.mule.extension.dynamodb.api.model.Record;
import org.mule.extension.dynamodb.api.model.Stream;
import org.mule.extension.dynamodb.api.model.StreamDescription;
import org.mule.extension.dynamodb.internal.config.DynamoDBStreamsConfiguration;
import org.mule.extension.dynamodb.internal.connection.DynamoDBStreamsConnection;
import org.mule.extension.dynamodb.internal.error.provider.DynamoDBErrorTypeProvider;
import org.mule.extension.dynamodb.internal.metadata.provider.TableValueProvider;
import org.mule.extension.dynamodb.internal.operation.paging.GetRecordsPagingProvider;
import org.mule.extension.dynamodb.internal.operation.paging.ListStreamsPagingProvider;
import org.mule.extension.dynamodb.internal.util.DynamoDBModelFactory;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.values.OfValues;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;

@Throws(value={DynamoDBErrorTypeProvider.class})
public class DynamoDBStreamsOperations {
    @Summary(value="List streams")
    public PagingProvider<DynamoDBStreamsConnection, Result<Stream, RequestIDAttribute>> listStreams(@Optional @OfValues(value=TableValueProvider.class) String tableName) {
        return new ListStreamsPagingProvider(new ListStreamsRequest().withTableName(tableName));
    }

    @Summary(value="Describe stream")
    public Result<StreamDescription, RequestIDAttribute> describeStream(@Config DynamoDBStreamsConfiguration config, @Connection DynamoDBStreamsConnection client, String streamARN) {
        return DynamoDBModelFactory.describeStream(client.describeStream(new DescribeStreamRequest().withStreamArn(streamARN)));
    }

    @Summary(value="Get shard iterator")
    @MediaType(value="text/plain")
    public Result<String, RequestIDAttribute> getShardIterator(@Config DynamoDBStreamsConfiguration config, @Connection DynamoDBStreamsConnection client, String shardId, @Summary(value="Determines how the shard iterator is used.") String shardIteratorType, @Optional String startingSequenceNumber, String streamARN) {
        return DynamoDBModelFactory.getShardIterator(client.getShardIterator(new GetShardIteratorRequest().withShardId(shardId).withStreamArn(streamARN).withShardIteratorType(shardIteratorType).withSequenceNumber(startingSequenceNumber)));
    }

    public PagingProvider<DynamoDBStreamsConnection, Result<Record, RequestIDAttribute>> getRecords(@Summary(value="A shard iterator that was retrieved from a previous GetShardIterator operation.") String shardIterator) {
        return new GetRecordsPagingProvider(new GetRecordsRequest().withShardIterator(shardIterator));
    }
}

