/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.dynamodb.internal.metadata;

import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.TableDescription;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.extension.dynamodb.internal.connection.DynamoDBConnection;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;

public class KeyInputMetadataResolver
implements InputTypeResolver<String> {
    public MetadataType getInputMetadata(MetadataContext context, String tableName) throws ConnectionException, MetadataResolvingException {
        DynamoDBConnection dynamoDBConnection = (DynamoDBConnection)((Object)context.getConnection().orElseThrow(() -> new MetadataResolvingException("An error occurred while trying to validate the connection.", FailureCode.CONNECTION_FAILURE)));
        TableDescription tableDescription = dynamoDBConnection.describeTable(tableName).getTable();
        List keySchemasAttributes = tableDescription.getKeySchema().stream().map(KeySchemaElement::getAttributeName).collect(Collectors.toList());
        List<AttributeDefinition> attributeDefinitions = tableDescription.getAttributeDefinitions().stream().filter(attributeDefinition -> keySchemasAttributes.contains(attributeDefinition.getAttributeName())).collect(Collectors.toList());
        return this.loadClassMetadata(context, attributeDefinitions);
    }

    private MetadataType loadClassMetadata(MetadataContext context, List<AttributeDefinition> allFields) {
        ObjectTypeBuilder objectBuilder = context.getTypeBuilder().objectType();
        allFields.forEach(field -> {
            ObjectTypeBuilder objectTypeBuilderKey = objectBuilder.addField().key(field.getAttributeName()).value().objectType();
            BaseTypeBuilder baseTypeBuilder = objectTypeBuilderKey.addField().key(field.getAttributeType().toLowerCase()).value();
            if ("b".equalsIgnoreCase(field.getAttributeType())) {
                baseTypeBuilder.binaryType();
            } else {
                baseTypeBuilder.stringType();
            }
        });
        return objectBuilder.build();
    }

    public String getCategoryName() {
        return "KeyInput";
    }
}

