/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.dynamodb.internal.connection;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBAsync;
import com.amazonaws.services.dynamodbv2.model.AmazonDynamoDBException;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchGetItemResult;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemRequest;
import com.amazonaws.services.dynamodbv2.model.BatchWriteItemResult;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.CreateTableResult;
import com.amazonaws.services.dynamodbv2.model.DeleteItemRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteItemResult;
import com.amazonaws.services.dynamodbv2.model.DeleteTableResult;
import com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.ListTablesRequest;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.dynamodbv2.model.PutItemRequest;
import com.amazonaws.services.dynamodbv2.model.PutItemResult;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import com.amazonaws.services.dynamodbv2.model.QueryResult;
import com.amazonaws.services.dynamodbv2.model.ScanRequest;
import com.amazonaws.services.dynamodbv2.model.ScanResult;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateTableResult;
import org.mule.extension.aws.commons.internal.connection.AWSConnection;
import org.mule.extension.aws.commons.internal.exception.AWSConnectionException;

public class DynamoDBConnection
extends AWSConnection<AmazonDynamoDB, AmazonDynamoDBAsync> {
    public DynamoDBConnection(AmazonDynamoDB awsClient, AmazonDynamoDBAsync awsAsyncClient) {
        super((Object)awsClient, (Object)awsAsyncClient);
    }

    public BatchWriteItemResult batchWriteItem(BatchWriteItemRequest batchWriteItemRequest) {
        return ((AmazonDynamoDB)this.getAwsClient()).batchWriteItem(batchWriteItemRequest);
    }

    public BatchGetItemResult batchGetItem(BatchGetItemRequest batchGetItemRequest) {
        return ((AmazonDynamoDB)this.getAwsClient()).batchGetItem(batchGetItemRequest);
    }

    public GetItemResult getItem(GetItemRequest getItemRequest) {
        return ((AmazonDynamoDB)this.getAwsClient()).getItem(getItemRequest);
    }

    public PutItemResult putItem(PutItemRequest putItemRequest) {
        return ((AmazonDynamoDB)this.getAwsClient()).putItem(putItemRequest);
    }

    public DeleteItemResult deleteItem(DeleteItemRequest deleteItemRequest) {
        return ((AmazonDynamoDB)this.getAwsClient()).deleteItem(deleteItemRequest);
    }

    public UpdateItemResult updateItem(UpdateItemRequest updateItemRequest) {
        return ((AmazonDynamoDB)this.getAwsClient()).updateItem(updateItemRequest);
    }

    public CreateTableResult createTable(CreateTableRequest createTableRequest) {
        return ((AmazonDynamoDB)this.getAwsClient()).createTable(createTableRequest);
    }

    public DescribeTableResult describeTable(String tableName) {
        return ((AmazonDynamoDB)this.getAwsClient()).describeTable(tableName);
    }

    public ListTablesResult listTables(ListTablesRequest listTablesRequest) {
        return ((AmazonDynamoDB)this.getAwsClient()).listTables(listTablesRequest);
    }

    public ListTablesResult listTables() {
        return ((AmazonDynamoDB)this.getAwsClient()).listTables();
    }

    public UpdateTableResult updateTable(UpdateTableRequest updateTableRequest) {
        return ((AmazonDynamoDB)this.getAwsClient()).updateTable(updateTableRequest);
    }

    public QueryResult query(QueryRequest queryRequest) {
        return ((AmazonDynamoDB)this.getAwsClient()).query(queryRequest);
    }

    public ScanResult scan(ScanRequest scanRequest) {
        return ((AmazonDynamoDB)this.getAwsClient()).scan(scanRequest);
    }

    public DeleteTableResult deleteTable(String tableName) {
        return ((AmazonDynamoDB)this.getAwsClient()).deleteTable(tableName);
    }

    public void validate() throws AWSConnectionException {
        try {
            ((AmazonDynamoDB)this.getAwsClient()).listTables();
        }
        catch (AmazonDynamoDBException e) {
            throw new AWSConnectionException("An error occurred while trying to validate the connection.", (Throwable)e);
        }
    }
}

