/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.aws.commons.internal.connection.provider;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsAsyncClientBuilder;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.regions.Regions;
import com.amazonaws.retry.PredefinedRetryPolicies;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.mule.connectors.commons.template.connection.ConnectorConnectionProvider;
import org.mule.extension.aws.commons.internal.connection.AWSConnection;
import org.mule.extension.aws.commons.internal.connection.provider.parameter.CommonParameters;
import org.mule.extension.aws.commons.internal.connection.provider.parameter.ProxyParameterGroup;
import org.mule.extension.aws.commons.internal.exception.AWSConnectionException;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

public abstract class AWSConnectionProvider<AWS_CLIENT, AWS_ASYNC_CLIENT, AWS_CLIENT_BUILDER extends AwsClientBuilder<AWS_CLIENT_BUILDER, AWS_CLIENT>, AWS_ASYNC_CLIENT_BUILDER extends AwsAsyncClientBuilder<AWS_ASYNC_CLIENT_BUILDER, AWS_ASYNC_CLIENT>, CONNECTION extends AWSConnection<AWS_CLIENT, AWS_ASYNC_CLIENT>>
extends ConnectorConnectionProvider
implements CachedConnectionProvider<CONNECTION>,
Initialisable {
    private final AWS_CLIENT_BUILDER clientBuilder;
    private final AWS_ASYNC_CLIENT_BUILDER asyncClientBuilder;
    private final BiFunction<AWS_CLIENT, AWS_ASYNC_CLIENT, CONNECTION> connectionConstructor;
    @ParameterGroup(name="Connection")
    @Placement(order=1)
    private CommonParameters commonParameters;
    @ParameterGroup(name="Proxy")
    @Placement(order=2)
    private ProxyParameterGroup proxyParameterGroup;

    public AWSConnectionProvider(BiFunction<AWS_CLIENT, AWS_ASYNC_CLIENT, CONNECTION> connectionConstructor, AWS_CLIENT_BUILDER clientBuilder, AWS_ASYNC_CLIENT_BUILDER asyncClientBuilder) {
        this.connectionConstructor = connectionConstructor;
        this.clientBuilder = clientBuilder;
        this.asyncClientBuilder = asyncClientBuilder;
    }

    public void initialise() throws InitialisationException {
        TlsContextFactory tlsContextFactory = this.commonParameters.getTlsContext();
        if (tlsContextFactory instanceof Initialisable) {
            ((Initialisable)tlsContextFactory).initialise();
        }
    }

    protected ClientConfiguration getClientConfiguration() throws NoSuchAlgorithmException, KeyManagementException {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        if (this.proxyParameterGroup != null) {
            Optional.ofNullable(this.proxyParameterGroup.getProxyDomain()).ifPresent(arg_0 -> ((ClientConfiguration)clientConfiguration).setProxyDomain(arg_0));
            Optional.ofNullable(this.proxyParameterGroup.getProxyUsername()).ifPresent(arg_0 -> ((ClientConfiguration)clientConfiguration).setProxyUsername(arg_0));
            Optional.ofNullable(this.proxyParameterGroup.getProxyHost()).ifPresent(arg_0 -> ((ClientConfiguration)clientConfiguration).setProxyHost(arg_0));
            Optional.ofNullable(this.proxyParameterGroup.getProxyPassword()).ifPresent(arg_0 -> ((ClientConfiguration)clientConfiguration).setProxyPassword(arg_0));
            Optional.ofNullable(this.proxyParameterGroup.getProxyPort()).ifPresent(arg_0 -> ((ClientConfiguration)clientConfiguration).setProxyPort(arg_0));
            Optional.ofNullable(this.proxyParameterGroup.getProxyWorkstation()).ifPresent(arg_0 -> ((ClientConfiguration)clientConfiguration).setProxyWorkstation(arg_0));
        }
        if (this.commonParameters.getTlsContext() != null) {
            clientConfiguration.getApacheHttpClientConfig().setSslSocketFactory((ConnectionSocketFactory)new SSLConnectionSocketFactory(this.commonParameters.getTlsContext().createSslContext()));
        }
        clientConfiguration.setSocketTimeout(this.commonParameters.getSocketTimeout().intValue());
        clientConfiguration.setConnectionTimeout(this.commonParameters.getConnectionTimeout().intValue());
        clientConfiguration.setRetryPolicy(PredefinedRetryPolicies.NO_RETRY_POLICY);
        return clientConfiguration;
    }

    public CONNECTION connect() throws ConnectionException {
        try {
            ClientConfiguration clientConfiguration = this.getClientConfiguration();
            this.configureRegionProperty(this.clientBuilder, this.asyncClientBuilder);
            this.appendClientConfigurationProperties(clientConfiguration);
            this.clientBuilder.withClientConfiguration(clientConfiguration);
            this.asyncClientBuilder.withClientConfiguration(clientConfiguration);
            if (!(this.commonParameters.isTryDefaultAWSCredentialsProviderChain() || Optional.ofNullable(this.commonParameters.getAccessKey()).filter(Predicate.isEqual("").negate()).isPresent() && Optional.ofNullable(this.commonParameters.getSecretKey()).filter(Predicate.isEqual("").negate()).isPresent())) {
                throw new AWSConnectionException("Access Key or Secret Key is blank");
            }
            this.clientBuilder.withCredentials(this.getAWSCredentialsProvider(this.commonParameters));
            this.asyncClientBuilder.withCredentials(this.getAWSCredentialsProvider(this.commonParameters));
            this.appendBuilderProperties(this.clientBuilder, this.asyncClientBuilder);
            AwsSdkMetrics.unregisterMetricAdminMBean();
            AWSConnection connection = (AWSConnection)this.connectionConstructor.apply(this.clientBuilder.build(), this.asyncClientBuilder.build());
            this.onConnect(connection);
            return (CONNECTION)connection;
        }
        catch (KeyManagementException | NoSuchAlgorithmException | AWSConnectionException e) {
            throw new ConnectionException(e.getMessage(), (Throwable)e);
        }
    }

    protected void onConnect(CONNECTION connection) {
    }

    protected void appendBuilderProperties(AWS_CLIENT_BUILDER clientBuilder, AWS_ASYNC_CLIENT_BUILDER asyncClientBuilder) {
    }

    protected String getRegion() {
        try {
            return Regions.valueOf((String)this.commonParameters.getRegion()).getName();
        }
        catch (IllegalArgumentException e) {
            return this.commonParameters.getRegion().toLowerCase().replace("_", "-");
        }
    }

    protected void configureRegionProperty(AWS_CLIENT_BUILDER clientBuilder, AWS_ASYNC_CLIENT_BUILDER asyncClientBuilder) {
        String region = this.getRegion();
        String serviceEndpoint = this.commonParameters.getCustomServiceEndpoint();
        if (serviceEndpoint != null && !serviceEndpoint.isEmpty()) {
            AwsClientBuilder.EndpointConfiguration endpointConfig = new AwsClientBuilder.EndpointConfiguration(this.commonParameters.getCustomServiceEndpoint(), region);
            clientBuilder.withEndpointConfiguration(endpointConfig);
            asyncClientBuilder.withEndpointConfiguration(endpointConfig);
        } else {
            clientBuilder.setRegion(region);
            asyncClientBuilder.setRegion(region);
        }
    }

    protected abstract AWSCredentialsProvider getAWSCredentialsProvider(CommonParameters var1) throws ConnectionException;

    protected void appendClientConfigurationProperties(ClientConfiguration configuration) {
    }

    public void disconnect(CONNECTION connection) {
        super.disconnect(connection);
    }

    public ConnectionValidationResult validate(CONNECTION connection) {
        return super.validate(connection);
    }

    public CommonParameters getCommonParameters() {
        return this.commonParameters;
    }

    public void setCommonParameters(CommonParameters commonParameters) {
        this.commonParameters = commonParameters;
    }

    public void setProxyParameterGroup(ProxyParameterGroup proxyParameterGroup) {
        this.proxyParameterGroup = proxyParameterGroup;
    }
}

