/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.aws.commons.internal.exception;

import com.amazonaws.AmazonServiceException;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.mule.connectors.atlantic.commons.builder.exception.ConversionException;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.exception.ExceptionHandler;

public class AWSExceptionHandler<T extends Enum<T>>
extends ExceptionHandler {
    private final Class<T> enumType;
    private final Set<String> stringTypes;

    public AWSExceptionHandler(Class<T> enumType) {
        this.enumType = enumType;
        this.stringTypes = Stream.of(enumType.getEnumConstants()).map(Object::toString).collect(Collectors.toSet());
    }

    public Exception enrichException(Exception e) {
        return new ModuleException(Optional.of(e).filter(AmazonServiceException.class::isInstance).map(AmazonServiceException.class::cast).map(AmazonServiceException::getErrorCode).map(code -> Stream.of(StringUtils.splitByCharacterTypeCamelCase((String)code.replace(".", ""))).map(String::toUpperCase).collect(Collectors.joining("_"))).filter(this.stringTypes::contains).map(code -> (ErrorTypeDefinition)Enum.valueOf(this.enumType, code)).orElse(Optional.of(e).filter(ConversionException.class::isInstance).map(Throwable::getCause).map(Exception.class::cast).map(this::enrichException).map(ModuleException.class::cast).map(ModuleException::getType).orElse((ErrorTypeDefinition)MuleErrors.ANY)), (Throwable)e);
    }
}

