/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.aws.commons.internal.operation;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.SdkClientException;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.mule.connectors.atlantic.commons.builder.execution.ExecutionBuilder;
import org.mule.connectors.atlantic.commons.builder.lambda.function.BiFunction;
import org.mule.connectors.commons.template.operation.ConnectorOperations;
import org.mule.connectors.commons.template.service.ConnectorService;
import org.mule.extension.aws.commons.internal.config.AWSConfig;
import org.mule.extension.aws.commons.internal.connection.AWSConnection;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.api.exception.ModuleException;

public class AWSOperations<CONFIG extends AWSConfig, CONNECTION extends AWSConnection<?, ?>, SERVICE extends ConnectorService>
extends ConnectorOperations<CONFIG, CONNECTION, SERVICE> {
    public AWSOperations(BiFunction<CONFIG, CONNECTION, SERVICE> serviceConstructor) {
        super(serviceConstructor);
    }

    protected ExecutionBuilder<SERVICE> newExecutionBuilder(CONFIG config, CONNECTION connection) {
        return (ExecutionBuilder)((ExecutionBuilder)((ExecutionBuilder)((ExecutionBuilder)super.newExecutionBuilder(config, connection).withExceptionHandler(AmazonServiceException.class, e -> {
            throw e;
        })).withExceptionHandler(AmazonClientException.class, e -> {
            throw e;
        })).withExceptionHandler(SdkClientException.class, e -> {
            if (e.getCause() instanceof UnknownHostException || e.getCause() instanceof SocketException) {
                throw this.wrapConnectivityException(e.getCause());
            }
            throw e;
        })).withExceptionHandler(IllegalStateException.class, e -> {
            if ("Connection pool shut down".equals(e.getCause().getMessage())) {
                throw this.wrapConnectivityException(e.getCause());
            }
            throw e;
        });
    }

    private ModuleException wrapConnectivityException(Throwable throwable) {
        return new ModuleException((ErrorTypeDefinition)MuleErrors.CONNECTIVITY, throwable);
    }
}

